/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import io.airlift.log.Logger;
import io.trino.testing.ResourcePresence;
import io.trino.testng.services.Listeners;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

public class ManageTestResources
implements ITestListener {
    private static final Logger log = Logger.get(ManageTestResources.class);
    private final boolean enabled = ManageTestResources.isEnabled();
    private final List<Rule> rules;

    public ManageTestResources() {
        if (!this.enabled) {
            log.info("ManageTestResources is disabled!");
            this.rules = List.of();
            return;
        }
        ImmutableList.Builder rules = ImmutableList.builder();
        rules.add((Object)ManageTestResources.isAutoCloseable());
        ManageTestResources.isInstanceTransactionManagerField().ifPresent(arg_0 -> ((ImmutableList.Builder)rules).add(arg_0));
        rules.add((Object)ManageTestResources.declaredClassPattern("org\\.testcontainers\\..*"));
        rules.add((Object)ManageTestResources.declaredClassPattern("com\\.github\\.dockerjava\\..*"));
        rules.add((Object)ManageTestResources.isSomeServer());
        rules.add((Object)ManageTestResources.isLeftoverExecutorService());
        this.rules = rules.build();
    }

    private static boolean isEnabled() {
        if (System.getProperty("ManageTestResources.enabled") != null) {
            return Boolean.getBoolean("ManageTestResources.enabled");
        }
        return System.getenv("DISABLE_REPORT_RESOURCE_HUNGRY_TESTS_CHECK") == null;
    }

    public void onStart(ITestContext context) {
        try {
            if (!this.enabled) {
                log.debug("ManageTestResources.onStart ignored, check is disabled");
                return;
            }
            log.info("ManageTestResources.onStart: running checks");
            this.manageResources(context, Stage.BEFORE_CLASS);
        }
        catch (Error | ReflectiveOperationException e) {
            Listeners.reportListenerFailure(ManageTestResources.class, "Failed to process %s: \n%s", context, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void onTestStart(ITestResult result) {
    }

    public void onTestSuccess(ITestResult result) {
    }

    public void onTestFailure(ITestResult result) {
    }

    public void onTestSkipped(ITestResult result) {
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
    }

    public void onFinish(ITestContext context) {
        try {
            if (!this.enabled) {
                log.debug("ManageTestResources.onFinish ignored, check is disabled");
                return;
            }
            log.info("ManageTestResources.onFinish: running checks");
            this.manageResources(context, Stage.AFTER_CLASS);
        }
        catch (Error | ReflectiveOperationException e) {
            Listeners.reportListenerFailure(ManageTestResources.class, "Failed to process %s: \n%s", context, Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void manageResources(ITestContext context, Stage stage) throws ReflectiveOperationException {
        Set testClasses = (Set)Stream.of(context.getAllTestMethods()).map(ITestNGMethod::getTestClass).collect(ImmutableSet.toImmutableSet());
        for (ITestClass testClass : testClasses) {
            this.manageResources(testClass, stage);
        }
    }

    private void manageResources(ITestClass testClass, Stage stage) throws ReflectiveOperationException {
        Preconditions.checkState((boolean)this.enabled, (Object)"Not enabled");
        for (Object instance : testClass.getInstances(false)) {
            for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                for (Field field : clazz.getDeclaredFields()) {
                    if (field.isAnnotationPresent(Suppress.class)) {
                        log.debug("Skipping audit of field due to field-level suppression %s: %s", new Object[]{field.getAnnotation(Suppress.class), field});
                        continue;
                    }
                    field.setAccessible(true);
                    Object value = field.get(instance);
                    if (value == null) continue;
                    if (value.getClass().isAnnotationPresent(Suppress.class)) {
                        log.debug("Skipping audit of field due to suppression %s on the field actual type (%s): %s", new Object[]{value.getClass().getAnnotation(Suppress.class), value.getClass(), field});
                        continue;
                    }
                    for (Rule rule : this.rules) {
                        if (!rule.isExpensiveResource(field, value, stage)) continue;
                        Listeners.reportListenerFailure(ManageTestResources.class, "\n\tTest instance field has value that looks like a resource\n\t    Test class: %s\n\t    Instance: %s\n\t    Field: %s\n\t    Value: %s\n\t    Test execution stage: %s\n\t    Matching rule: %s\n\n\tResources must not be allocated in a field initializer or a test constructor,\n\tand must be freed when test class is completed.\n\tDepending which rule has been violated, if the reported class holds on\n\tto resources only conditionally, you can add @ResourcePresence to declare that.\n", new Object[]{testClass.getRealClass(), instance, field, value, stage, rule});
                    }
                }
            }
        }
    }

    private static Rule declaredClassPattern(@Language(value="RegExp") String classNamePattern) {
        Pattern pattern = Pattern.compile(classNamePattern);
        return ManageTestResources.named("declaredClassPattern(%s)".formatted(classNamePattern), (field, value, stage) -> pattern.matcher(field.getType().getName()).matches());
    }

    private static Rule isAutoCloseable() {
        return ManageTestResources.named("isAutoCloseable", (field, value, stage) -> {
            if (!(value instanceof AutoCloseable)) {
                return false;
            }
            if (value instanceof ExecutorService) {
                return false;
            }
            return stage != Stage.AFTER_CLASS || !ManageTestResources.isResourceStopped(value);
        });
    }

    private static Rule isSomeServer() {
        return ManageTestResources.named("isSomeServer", (field, value, stage) -> {
            Class<?> type = field.getType();
            if (!type.getName().endsWith("Server")) {
                return false;
            }
            return stage != Stage.AFTER_CLASS || !ManageTestResources.isResourceStopped(value);
        });
    }

    private static Optional<Rule> isInstanceTransactionManagerField() {
        return ManageTestResources.tryLoadClass("io.trino.transaction.TransactionManager").map(transactionManagerClass -> ManageTestResources.named("is-instance-TransactionManager-field", (field, value, stage) -> {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            return transactionManagerClass.isInstance(value);
        }));
    }

    private static boolean isResourceStopped(Object resource) {
        return ((Optional)Stream.of(resource.getClass().getMethods()).filter(method -> method.isAnnotationPresent(ResourcePresence.class)).collect(MoreCollectors.toOptional())).map(resourcePresence -> {
            try {
                return (Boolean)resourcePresence.invoke(resource, new Object[0]) == false;
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        }).orElse(false);
    }

    private static Rule isLeftoverExecutorService() {
        return ManageTestResources.named("isLeftoverExecutorService", (field, value, stage) -> {
            if (!(value instanceof ExecutorService)) {
                return false;
            }
            ExecutorService executorService = (ExecutorService)value;
            return stage == Stage.AFTER_CLASS && !executorService.isShutdown();
        });
    }

    private static Rule named(final String name, final Rule delegate) {
        return new Rule(){

            @Override
            public boolean isExpensiveResource(Field field, Object value, Stage stage) {
                return delegate.isExpensiveResource(field, value, stage);
            }

            public String toString() {
                return name;
            }
        };
    }

    private static Optional<Class<?>> tryLoadClass(String className) {
        try {
            return Optional.of(Thread.currentThread().getContextClassLoader().loadClass(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    @FunctionalInterface
    private static interface Rule {
        public boolean isExpensiveResource(Field var1, Object var2, Stage var3);
    }

    static enum Stage {
        BEFORE_CLASS,
        AFTER_CLASS;

    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    @Inherited
    public static @interface Suppress {
        public String because();
    }
}

