/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testng.services;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.testng.services.Listeners;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.concurrent.GuardedBy;
import org.testng.IClassListener;
import org.testng.IExecutionListener;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestClass;
import org.testng.ITestResult;

public class LogTestDurationListener
implements IExecutionListener,
IClassListener,
IInvokedMethodListener {
    private static final Logger LOG = Logger.get(LogTestDurationListener.class);
    private static final Duration SINGLE_TEST_LOGGING_THRESHOLD = new Duration(30.0, TimeUnit.SECONDS);
    private static final Duration CLASS_LOGGING_THRESHOLD = new Duration(1.0, TimeUnit.MINUTES);
    private static final Duration GLOBAL_IDLE_LOGGING_THRESHOLD = new Duration(8.0, TimeUnit.MINUTES);
    private final boolean enabled;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<String, Long> started = new ConcurrentHashMap<String, Long>();
    private final AtomicLong lastChange = new AtomicLong(System.nanoTime());
    private final AtomicBoolean hangLogged = new AtomicBoolean();
    private final AtomicBoolean finished = new AtomicBoolean();
    @GuardedBy(value="this")
    private ScheduledFuture<?> monitorHangTask;

    public LogTestDurationListener() {
        this.enabled = LogTestDurationListener.isEnabled();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"TestHangMonitor"));
        LOG.info("LogTestDurationListener enabled: %s", new Object[]{this.enabled});
    }

    private static boolean isEnabled() {
        if (System.getProperty("LogTestDurationListener.enabled") != null) {
            return Boolean.getBoolean("LogTestDurationListener.enabled");
        }
        return System.getenv("CONTINUOUS_INTEGRATION") != null;
    }

    public synchronized void onExecutionStart() {
        if (!this.enabled) {
            return;
        }
        try {
            this.resetHangMonitor();
            this.finished.set(false);
            if (this.monitorHangTask == null) {
                this.monitorHangTask = this.scheduledExecutorService.scheduleWithFixedDelay(this::checkForTestHang, 5L, 5L, TimeUnit.SECONDS);
            }
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "onExecutionStart: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public synchronized void onExecutionFinish() {
        if (!this.enabled) {
            return;
        }
        try {
            this.resetHangMonitor();
            this.finished.set(true);
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "onExecutionFinish: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void checkForTestHang() {
        if (this.hangLogged.get()) {
            return;
        }
        Duration duration = Duration.nanosSince((long)this.lastChange.get());
        if (duration.compareTo(GLOBAL_IDLE_LOGGING_THRESHOLD) < 0) {
            return;
        }
        if (!this.hangLogged.compareAndSet(false, true)) {
            return;
        }
        ImmutableMap runningTests = ImmutableMap.copyOf(this.started);
        if (!runningTests.isEmpty()) {
            String testDetails = runningTests.entrySet().stream().map(entry -> String.format("%s running for %s", entry.getKey(), Duration.nanosSince((long)((Long)entry.getValue())))).collect(Collectors.joining("\n\t", "\n\t", ""));
            LogTestDurationListener.dumpAllThreads(String.format("No test started or completed in %s. Running tests:%s.", GLOBAL_IDLE_LOGGING_THRESHOLD, testDetails));
        } else if (this.finished.get()) {
            LogTestDurationListener.dumpAllThreads(String.format("Tests finished, but JVM did not shutdown in %s.", GLOBAL_IDLE_LOGGING_THRESHOLD));
        } else {
            LogTestDurationListener.dumpAllThreads(String.format("No test started in %s", GLOBAL_IDLE_LOGGING_THRESHOLD));
        }
    }

    private static void dumpAllThreads(String message) {
        LOG.warn("%s\n\nFull Thread Dump:\n%s", new Object[]{message, Arrays.stream(ManagementFactory.getThreadMXBean().dumpAllThreads(true, true)).map(io.trino.jvm.Threads::fullToString).collect(Collectors.joining("\n"))});
    }

    private void resetHangMonitor() {
        this.lastChange.set(System.nanoTime());
        this.hangLogged.set(false);
    }

    public void onBeforeClass(ITestClass testClass) {
        if (!this.enabled) {
            return;
        }
        try {
            this.beginTest(LogTestDurationListener.getName(testClass));
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "onBeforeClass: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void onAfterClass(ITestClass testClass) {
        if (!this.enabled) {
            return;
        }
        try {
            String name = LogTestDurationListener.getName(testClass);
            Duration duration = this.endTest(name);
            if (duration.compareTo(CLASS_LOGGING_THRESHOLD) > 0) {
                LOG.warn("Tests from %s took %s", new Object[]{name, duration});
            }
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "onAfterClass: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!this.enabled) {
            return;
        }
        try {
            this.beginTest(LogTestDurationListener.getName(method));
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "beforeInvocation: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
        if (!this.enabled) {
            return;
        }
        try {
            String name = LogTestDurationListener.getName(method);
            Duration duration = this.endTest(name);
            if (duration.compareTo(SINGLE_TEST_LOGGING_THRESHOLD) > 0) {
                LOG.info("Test %s took %s", new Object[]{name, duration});
            }
        }
        catch (Error | RuntimeException e) {
            Listeners.reportListenerFailure(LogTestDurationListener.class, "afterInvocation: \n%s", Throwables.getStackTraceAsString((Throwable)e));
        }
    }

    private void beginTest(String name) {
        this.resetHangMonitor();
        Long existingEntry = this.started.putIfAbsent(name, System.nanoTime());
        Preconditions.checkState((existingEntry == null ? 1 : 0) != 0, (String)"There already is a start record for test: %s", (Object)name);
    }

    private Duration endTest(String name) {
        this.resetHangMonitor();
        Long startTime = this.started.remove(name);
        Preconditions.checkState((startTime != null ? 1 : 0) != 0, (String)"There is no start record for test: %s", (Object)name);
        return Duration.nanosSince((long)startTime);
    }

    private static String getName(ITestClass testClass) {
        return testClass.getName();
    }

    private static String getName(IInvokedMethod method) {
        return String.format("%s.%s", method.getTestMethod().getTestClass().getName(), method.getTestMethod().getMethodName());
    }
}

