/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import java.net.URI;
import org.testcontainers.containers.GenericContainer;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.core.checksums.RequestChecksumCalculation;
import software.amazon.awssdk.core.checksums.ResponseChecksumValidation;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.LegacyMd5Plugin;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;

public final class MotoContainer
extends GenericContainer<MotoContainer> {
    public static final String MOTO_ACCESS_KEY = "accesskey";
    public static final String MOTO_SECRET_KEY = "secretkey";
    public static final String MOTO_REGION = "us-east-1";
    private static final int MOTO_PORT = 5000;

    public MotoContainer() {
        super("motoserver/moto:latest");
        this.addExposedPort(5000);
    }

    public URI getEndpoint() {
        return URI.create("http://" + this.getHost() + ":" + this.getMappedPort(5000));
    }

    public void updateClient(AwsClientBuilder<?, ?> client) {
        client.endpointOverride(this.getEndpoint());
        client.region(Region.of((String)MOTO_REGION));
        client.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)MOTO_ACCESS_KEY, (String)MOTO_SECRET_KEY)));
        if (client instanceof S3ClientBuilder) {
            S3ClientBuilder s3 = (S3ClientBuilder)client;
            s3.forcePathStyle(Boolean.valueOf(true));
            s3.responseChecksumValidation(ResponseChecksumValidation.WHEN_REQUIRED);
            s3.requestChecksumCalculation(RequestChecksumCalculation.WHEN_REQUIRED);
        }
        client.addPlugin(LegacyMd5Plugin.create());
    }

    public void createBucket(String bucketName) {
        try (S3Client s3 = (S3Client)((S3ClientBuilder)S3Client.builder().applyMutation(this::updateClient)).build();){
            s3.createBucket(builder -> builder.bucket(bucketName));
        }
    }
}

