/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import io.airlift.log.Logger;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public final class PrintingLogConsumer
extends BaseConsumer<PrintingLogConsumer> {
    private final Logger log;

    public PrintingLogConsumer(String name) {
        this.log = Logger.get((String)("container." + name));
    }

    public void accept(OutputFrame outputFrame) {
        if (!this.log.isInfoEnabled()) {
            return;
        }
        String message = outputFrame.getUtf8String().replaceAll("\\r?\\n?$", "");
        if (!message.isEmpty() || outputFrame.getType() != OutputFrame.OutputType.END) {
            this.log.info(message);
        }
        if (outputFrame.getType() == OutputFrame.OutputType.END) {
            this.log.info("(exited)");
        }
    }
}

