/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import io.airlift.log.Logger;
import java.util.Objects;
import org.testcontainers.containers.output.BaseConsumer;
import org.testcontainers.containers.output.OutputFrame;

public final class PrintingLogConsumer
extends BaseConsumer<PrintingLogConsumer> {
    private static final Logger log = Logger.get(PrintingLogConsumer.class);
    private final String prefix;

    public PrintingLogConsumer(String prefix) {
        this.prefix = Objects.requireNonNull(prefix, "prefix is null");
    }

    public void accept(OutputFrame outputFrame) {
        if (!log.isInfoEnabled()) {
            return;
        }
        String message = outputFrame.getUtf8String().replaceAll("\\r?\\n?$", "");
        if (!message.isEmpty() || outputFrame.getType() != OutputFrame.OutputType.END) {
            log.info("%s%s", new Object[]{this.prefix, message});
        }
        if (outputFrame.getType() == OutputFrame.OutputType.END) {
            log.info("%s(exited)", new Object[]{this.prefix});
        }
    }
}

