/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.containers;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.MountableFile;
import org.testcontainers.utility.TestcontainersConfiguration;

public final class TestContainers {
    private static final boolean TESTCONTAINERS_REUSE_ENABLE = Boolean.parseBoolean(System.getenv("TESTCONTAINERS_REUSE_ENABLE"));

    private TestContainers() {
    }

    public static Closeable startOrReuse(GenericContainer<?> container) {
        boolean reuse = TestcontainersConfiguration.getInstance().environmentSupportsReuse();
        Preconditions.checkState((reuse == TESTCONTAINERS_REUSE_ENABLE ? 1 : 0) != 0, (Object)"Unable to enable or disable container reuse");
        container.withReuse(TESTCONTAINERS_REUSE_ENABLE);
        container.start();
        if (reuse) {
            return () -> {};
        }
        return () -> container.stop();
    }

    public static String getPathFromClassPathResource(String resourcePath) {
        return MountableFile.forClasspathResource((String)resourcePath).getResolvedPath();
    }
}

