/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.teradata.functions;

import com.google.common.base.Throwables;
import com.google.common.io.BaseEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.FunctionDependency;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.lang.invoke.MethodHandle;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class TeradataStringFunctions {
    private TeradataStringFunctions() {
    }

    @Description(value="Returns index of first occurrence of a substring (or 0 if not found)")
    @ScalarFunction(value="index")
    @SqlType(value="bigint")
    public static long index(@FunctionDependency(name="strpos", argumentTypes={"varchar", "varchar"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle method, @SqlType(value="varchar") Slice string, @SqlType(value="varchar") Slice substring) {
        try {
            return method.invokeExact(string, substring);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="Returns the hexadecimal representation of the UTF-16BE encoding of the argument")
    @ScalarFunction(value="char2hexint")
    @SqlType(value="varchar")
    public static Slice char2HexInt(@SqlType(value="varchar") Slice string) {
        Slice utf16 = Slices.wrappedHeapBuffer((ByteBuffer)StandardCharsets.UTF_16BE.encode(string.toStringUtf8()));
        String encoded = BaseEncoding.base16().encode(utf16.getBytes());
        return Slices.utf8Slice((String)encoded);
    }
}

