/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.teradata.functions;

import com.google.common.base.Throwables;
import io.airlift.concurrent.ThreadLocalCache;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.teradata.functions.dateformat.DateFormatParser;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.joda.time.Chronology;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;

public final class TeradataDateFunctions {
    private static final ThreadLocalCache<Slice, DateTimeFormatter> DATETIME_FORMATTER_CACHE = new ThreadLocalCache(100, format -> DateFormatParser.createDateTimeFormatter(format.toStringUtf8()));
    private static final ISOChronology[] CHRONOLOGIES = new ISOChronology[TimeZoneKey.MAX_TIME_ZONE_KEY + 1];

    private TeradataDateFunctions() {
    }

    @Description(value="Converts a string to a DATE data type")
    @ScalarFunction(value="to_date")
    @SqlType(value="date")
    public static long toDate(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        try {
            long millis = TeradataDateFunctions.parseMillis(session.getLocale(), dateTime, formatString);
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        catch (Throwable t) {
            Throwables.throwIfInstanceOf((Throwable)t, Error.class);
            Throwables.throwIfInstanceOf((Throwable)t, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, t);
        }
    }

    @Description(value="Converts a string to a TIMESTAMP data type")
    @ScalarFunction(value="to_timestamp")
    @SqlType(value="timestamp(3)")
    public static long toTimestamp(ConnectorSession session, @SqlType(value="varchar") Slice dateTime, @SqlType(value="varchar") Slice formatString) {
        return TeradataDateFunctions.parseMillis(session, dateTime, formatString) * 1000L;
    }

    private static long parseMillis(ConnectorSession session, Slice dateTime, Slice formatString) {
        return TeradataDateFunctions.parseMillis(session.getLocale(), dateTime, formatString);
    }

    private static long parseMillis(Locale locale, Slice dateTime, Slice formatString) {
        DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withZoneUTC().withLocale(locale);
        try {
            return formatter.parseMillis(dateTime.toString(StandardCharsets.UTF_8));
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    static {
        for (TimeZoneKey timeZoneKey : TimeZoneKey.getTimeZoneKeys()) {
            DateTimeZone dateTimeZone = DateTimeZone.forID((String)timeZoneKey.getId());
            TeradataDateFunctions.CHRONOLOGIES[timeZoneKey.getKey()] = ISOChronology.getInstance((DateTimeZone)dateTimeZone);
        }
    }

    @Description(value="Formats a timestamp")
    @ScalarFunction(value="to_char")
    public static class ToChar {
        @LiteralParameters(value={"p"})
        @SqlType(value="varchar")
        public static Slice toChar(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") long timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
            DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)CHRONOLOGIES[DateTimeEncoding.unpackZoneKey((long)timestampWithTimeZone).getKey()]).withLocale(session.getLocale());
            return Slices.utf8Slice((String)formatter.print(DateTimeEncoding.unpackMillisUtc((long)timestampWithTimeZone)));
        }

        @LiteralParameters(value={"p"})
        @SqlType(value="varchar")
        public static Slice toChar(ConnectorSession session, @SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestampWithTimeZone, @SqlType(value="varchar") Slice formatString) {
            DateTimeFormatter formatter = ((DateTimeFormatter)DATETIME_FORMATTER_CACHE.get((Object)formatString)).withChronology((Chronology)CHRONOLOGIES[timestampWithTimeZone.getTimeZoneKey()]).withLocale(session.getLocale());
            return Slices.utf8Slice((String)formatter.print(timestampWithTimeZone.getEpochMillis()));
        }
    }
}

