/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.teradata.functions.dateformat;

import io.trino.plugin.teradata.functions.dateformat.DateFormat;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.Token;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public final class DateFormatParser {
    private DateFormatParser() {
    }

    public static DateTimeFormatter createDateTimeFormatter(String format) {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        block13: for (Token token : DateFormatParser.tokenize(format)) {
            switch (token.getType()) {
                case 9: {
                    builder.appendLiteral(token.getText());
                    continue block13;
                }
                case 1: {
                    builder.appendDayOfMonth(2);
                    continue block13;
                }
                case 2: {
                    builder.appendHourOfDay(2);
                    continue block13;
                }
                case 3: {
                    builder.appendHourOfHalfday(2);
                    continue block13;
                }
                case 5: {
                    builder.appendMinuteOfHour(2);
                    continue block13;
                }
                case 4: {
                    builder.appendMonthOfYear(2);
                    continue block13;
                }
                case 6: {
                    builder.appendSecondOfMinute(2);
                    continue block13;
                }
                case 8: {
                    builder.appendTwoDigitYear(2050);
                    continue block13;
                }
                case 7: {
                    builder.appendYear(4, 4);
                    continue block13;
                }
            }
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Failed to tokenize string [%s] at offset [%d]", token.getText(), token.getCharPositionInLine()));
        }
        try {
            return builder.toFormatter();
        }
        catch (UnsupportedOperationException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, (Throwable)e);
        }
    }

    public static List<? extends Token> tokenize(String format) {
        DateFormat lexer = new DateFormat((CharStream)CharStreams.fromString((String)format));
        return lexer.getAllTokens();
    }
}

