/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.sqlserver.SqlServerConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public class SqlServerSessionProperties
implements SessionPropertiesProvider {
    public static final String BULK_COPY_FOR_WRITE = "bulk_copy_for_write";
    public static final String BULK_COPY_FOR_WRITE_LOCK_DESTINATION_TABLE = "bulk_copy_for_write_lock_destination_table";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public SqlServerSessionProperties(SqlServerConfig config) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)BULK_COPY_FOR_WRITE, (String)"Use SQL Server Bulk Copy API for writes", (Boolean)config.isBulkCopyForWrite(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)BULK_COPY_FOR_WRITE_LOCK_DESTINATION_TABLE, (String)"Obtain a Bulk Update lock on destination table on write", (Boolean)config.isBulkCopyForWriteLockDestinationTable(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isBulkCopyForWrite(ConnectorSession session) {
        return (Boolean)session.getProperty(BULK_COPY_FOR_WRITE, Boolean.class);
    }

    public static boolean isBulkCopyForWriteLockDestinationTable(ConnectorSession session) {
        return (Boolean)session.getProperty(BULK_COPY_FOR_WRITE_LOCK_DESTINATION_TABLE, Boolean.class);
    }
}

