/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.opentelemetry.api.OpenTelemetry;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DriverConnectionFactory;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcJoinPushdownSupportModule;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.MaxDomainCompactionThreshold;
import io.trino.plugin.jdbc.credential.CredentialProvider;
import io.trino.plugin.jdbc.ptf.Procedure;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.sqlserver.SqlServerClient;
import io.trino.plugin.sqlserver.SqlServerConfig;
import io.trino.plugin.sqlserver.SqlServerConnectionFactory;
import io.trino.plugin.sqlserver.SqlServerSessionProperties;
import io.trino.plugin.sqlserver.SqlServerTableProperties;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.sql.Driver;

public class SqlServerClientModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(SqlServerConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcStatisticsConfig.class);
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(SqlServerClient.class).in(Scopes.SINGLETON);
        JdbcModule.bindTablePropertiesProvider((Binder)binder, SqlServerTableProperties.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, SqlServerSessionProperties.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(Integer.TYPE, MaxDomainCompactionThreshold.class)).setBinding().toInstance((Object)500);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
        this.install((Module)new JdbcJoinPushdownSupportModule());
        this.install(ConditionalModule.conditionalModule(SqlServerConfig.class, SqlServerConfig::isStoredProcedureTableFunctionEnabled, internalBinder -> Multibinder.newSetBinder((Binder)internalBinder, ConnectorTableFunction.class).addBinding().toProvider(Procedure.class).in(Scopes.SINGLETON)));
    }

    @Provides
    @Singleton
    @ForBaseJdbc
    public static ConnectionFactory getConnectionFactory(BaseJdbcConfig config, SqlServerConfig sqlServerConfig, CredentialProvider credentialProvider, OpenTelemetry openTelemetry) {
        return new SqlServerConnectionFactory((ConnectionFactory)DriverConnectionFactory.builder((Driver)new SQLServerDriver(), (String)config.getConnectionUrl(), (CredentialProvider)credentialProvider).setOpenTelemetry(openTelemetry).build(), sqlServerConfig.isSnapshotIsolationDisabled());
    }
}

