/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;

public class SqlServerConfig {
    private boolean snapshotIsolationDisabled;
    private boolean bulkCopyForWrite;
    private boolean bulkCopyForWriteLockDestinationTable;
    private boolean storedProcedureTableFunctionEnabled;

    public boolean isBulkCopyForWrite() {
        return this.bulkCopyForWrite;
    }

    @Config(value="sqlserver.bulk-copy-for-write.enabled")
    @ConfigDescription(value="Use SQL Server Bulk Copy API for writes")
    public SqlServerConfig setBulkCopyForWrite(boolean bulkCopyForWrite) {
        this.bulkCopyForWrite = bulkCopyForWrite;
        return this;
    }

    public boolean isBulkCopyForWriteLockDestinationTable() {
        return this.bulkCopyForWriteLockDestinationTable;
    }

    @Config(value="sqlserver.bulk-copy-for-write.lock-destination-table")
    @ConfigDescription(value="Obtain a Bulk Update lock on destination table on write")
    public SqlServerConfig setBulkCopyForWriteLockDestinationTable(boolean bulkCopyForWriteLockDestinationTable) {
        this.bulkCopyForWriteLockDestinationTable = bulkCopyForWriteLockDestinationTable;
        return this;
    }

    public boolean isSnapshotIsolationDisabled() {
        return this.snapshotIsolationDisabled;
    }

    @Config(value="sqlserver.snapshot-isolation.disabled")
    @ConfigDescription(value="Disables automatic use of snapshot isolation for transactions issued by Trino in SQL Server")
    public SqlServerConfig setSnapshotIsolationDisabled(boolean snapshotIsolationDisabled) {
        this.snapshotIsolationDisabled = snapshotIsolationDisabled;
        return this;
    }

    public boolean isStoredProcedureTableFunctionEnabled() {
        return this.storedProcedureTableFunctionEnabled;
    }

    @Config(value="sqlserver.experimental.stored-procedure-table-function-enabled")
    @ConfigDescription(value="Allows accessing Stored procedure as a table function")
    public SqlServerConfig setStoredProcedureTableFunctionEnabled(boolean storedProcedureTableFunctionEnabled) {
        this.storedProcedureTableFunctionEnabled = storedProcedureTableFunctionEnabled;
        return this;
    }
}

