/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.cache.CacheBuilder;
import io.trino.collect.cache.NonEvictableCache;
import io.trino.collect.cache.SafeCaches;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;

public class SqlServerConnectionFactory
implements ConnectionFactory {
    private final NonEvictableCache<SnapshotIsolationEnabledCacheKey, Boolean> snapshotIsolationEnabled = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(Duration.ofMinutes(5L)));
    private final ConnectionFactory delegate;
    private final boolean snapshotIsolationDisabled;

    public SqlServerConnectionFactory(ConnectionFactory delegate, boolean snapshotIsolationDisabled) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.snapshotIsolationDisabled = snapshotIsolationDisabled;
    }

    public Connection openConnection(ConnectorSession session) throws SQLException {
        Connection connection = this.delegate.openConnection(session);
        try {
            this.prepare(connection);
        }
        catch (SQLException e) {
            Connection ignored = connection;
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        return connection;
    }

    private void prepare(Connection connection) throws SQLException {
        if (this.snapshotIsolationDisabled) {
            return;
        }
        try {
            if (this.hasSnapshotIsolationEnabled(connection)) {
                connection.setTransactionIsolation(4096);
            }
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
    }

    private boolean hasSnapshotIsolationEnabled(Connection connection) throws SQLException {
        try {
            return (Boolean)this.snapshotIsolationEnabled.get((Object)SnapshotIsolationEnabledCacheKey.INSTANCE, () -> {
                Handle handle = Jdbi.open((Connection)connection);
                return ((Query)handle.createQuery("SELECT snapshot_isolation_state FROM sys.databases WHERE name = :name").bind("name", connection.getCatalog())).mapTo(Boolean.class).findOne().orElse(false);
            });
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    public void close() throws SQLException {
        this.delegate.close();
    }

    private static enum SnapshotIsolationEnabledCacheKey {
        INSTANCE;

    }
}

