/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.sqlserver;

import com.google.common.base.Enums;
import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcOutputTableHandle;
import io.trino.plugin.jdbc.JdbcSplit;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.AggregateFunctionRewriter;
import io.trino.plugin.jdbc.expression.ImplementAvgDecimal;
import io.trino.plugin.jdbc.expression.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.expression.ImplementCount;
import io.trino.plugin.jdbc.expression.ImplementCountAll;
import io.trino.plugin.jdbc.expression.ImplementMinMax;
import io.trino.plugin.jdbc.expression.ImplementSum;
import io.trino.plugin.sqlserver.DataCompression;
import io.trino.plugin.sqlserver.ImplementAvgBigint;
import io.trino.plugin.sqlserver.ImplementSqlServerStddevPop;
import io.trino.plugin.sqlserver.ImplementSqlServerStdev;
import io.trino.plugin.sqlserver.ImplementSqlServerVariance;
import io.trino.plugin.sqlserver.ImplementSqlServerVariancePop;
import io.trino.plugin.sqlserver.SqlServerTableProperties;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.Duration;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;

public class SqlServerClient
extends BaseJdbcClient {
    public static final int SQL_SERVER_MAX_LIST_EXPRESSIONS = 500;
    private static final Joiner DOT_JOINER = Joiner.on((String)".");
    private final Cache<SnapshotIsolationEnabledCacheKey, Boolean> snapshotIsolationEnabled = CacheBuilder.newBuilder().maximumSize(1L).expireAfterWrite(Duration.ofMinutes(5L)).build();
    private final AggregateFunctionRewriter aggregateFunctionRewriter;
    private static final int MAX_SUPPORTED_TEMPORAL_PRECISION = 7;

    @Inject
    public SqlServerClient(BaseJdbcConfig config, ConnectionFactory connectionFactory) {
        super(config, "\"", connectionFactory);
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(arg_0 -> ((SqlServerClient)this).quoted(arg_0), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax()).add((Object)new ImplementSum(SqlServerClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementSqlServerStdev()).add((Object)new ImplementSqlServerStddevPop()).add((Object)new ImplementSqlServerVariance()).add((Object)new ImplementSqlServerVariancePop()).build());
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        String sql = String.format("sp_rename %s, %s", SqlServerClient.singleQuote(catalogName, schemaName, tableName), SqlServerClient.singleQuote(newTable.getTableName()));
        this.execute(session, sql);
    }

    public void renameColumn(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle jdbcColumn, String newColumnName) {
        String sql = String.format("sp_rename %s, %s, 'COLUMN'", SqlServerClient.singleQuote(handle.getCatalogName(), handle.getSchemaName(), handle.getTableName(), jdbcColumn.getColumnName()), SqlServerClient.singleQuote(newColumnName));
        this.execute(session, sql);
    }

    protected void copyTableSchema(Connection connection, String catalogName, String schemaName, String tableName, String newTableName, List<String> columnNames) {
        String sql = String.format("SELECT %s INTO %s FROM %s WHERE 0 = 1", columnNames.stream().map(arg_0 -> ((SqlServerClient)this).quoted(arg_0)).collect(Collectors.joining(", ")), this.quoted(catalogName, schemaName, newTableName), this.quoted(catalogName, schemaName, tableName));
        this.execute(connection, sql);
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName;
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle))) {
            case "varbinary": {
                return Optional.of(SqlServerClient.varbinaryColumnMapping());
            }
        }
        switch (typeHandle.getJdbcType()) {
            case -7: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case -6: {
                return Optional.of(StandardColumnMappings.tinyintColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: 
            case 3: {
                int columnSize = typeHandle.getRequiredColumnSize();
                int decimalDigits = typeHandle.getRequiredDecimalDigits();
                int precision = columnSize + Math.max(-decimalDigits, 0);
                if (precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case -15: 
            case 1: {
                return Optional.of(StandardColumnMappings.defaultCharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -9: 
            case 12: {
                return Optional.of(StandardColumnMappings.defaultVarcharColumnMapping((int)typeHandle.getRequiredColumnSize(), (boolean)false));
            }
            case -4: 
            case -3: 
            case -2: {
                return Optional.of(SqlServerClient.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMapping());
            }
            case 92: {
                TimeType timeType = TimeType.createTimeType((int)typeHandle.getRequiredDecimalDigits());
                return Optional.of(ColumnMapping.longMapping((Type)timeType, (LongReadFunction)StandardColumnMappings.timeReadFunction((TimeType)timeType), (LongWriteFunction)this.sqlServerTimeWriteFunction(timeType.getPrecision())));
            }
            case 93: {
                int precision = typeHandle.getRequiredDecimalDigits();
                return Optional.of(StandardColumnMappings.timestampColumnMapping((TimestampType)TimestampType.createTimestampType((int)precision)));
            }
        }
        return this.legacyToPrestoType(session, connection, typeHandle);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"bit", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"tinyint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() || varcharType.getBoundedLength() > 4000 ? "nvarchar(max)" : "nvarchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            Object dataType = charType.getLength() > 4000 ? "nvarchar(max)" : "nchar(" + charType.getLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarbinaryType) {
            return WriteMapping.sliceMapping((String)"varbinary(max)", (SliceWriteFunction)SqlServerClient.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            int precision = Math.min(timeType.getPrecision(), 7);
            String dataType = String.format("time(%d)", precision);
            return WriteMapping.longMapping((String)dataType, (LongWriteFunction)this.sqlServerTimeWriteFunction(precision));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            String dataType = String.format("datetime2(%d)", Math.min(timestampType.getPrecision(), 7));
            if (timestampType.getPrecision() <= 6) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.timestampWriteFunction((TimestampType)timestampType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longTimestampWriteFunction((TimestampType)timestampType));
        }
        return this.legacyToWriteMapping(session, type);
    }

    private LongWriteFunction sqlServerTimeWriteFunction(final int precision) {
        return new LongWriteFunction(){

            public String getBindExpression() {
                return String.format("CAST(? AS time(%s))", precision);
            }

            public void set(PreparedStatement statement, int index, long picosOfDay) throws SQLException {
                if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                    picosOfDay = 0L;
                }
                LocalTime localTime = StandardColumnMappings.fromTrinoTime((long)picosOfDay);
                statement.setString(index, localTime.toString());
            }
        };
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> String.format("SELECT TOP %s * FROM (%s) o", limit, sql));
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<SortItem> sortOrder) {
        Map columns = (Map)this.getColumns(session, handle).stream().collect(ImmutableMap.toImmutableMap(JdbcColumnHandle::getColumnName, Function.identity()));
        for (SortItem sortItem : sortOrder) {
            Verify.verify((boolean)columns.containsKey(sortItem.getName()));
            Type sortItemType = ((JdbcColumnHandle)columns.get(sortItem.getName())).getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType)) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().flatMap(sortItem -> {
                String ordering = sortItem.getSortOrder().isAscending() ? "ASC" : "DESC";
                String columnSorting = String.format("%s %s", this.quoted(sortItem.getName()), ordering);
                switch (sortItem.getSortOrder()) {
                    case ASC_NULLS_FIRST: 
                    case DESC_NULLS_LAST: {
                        return Stream.of(columnSorting);
                    }
                    case ASC_NULLS_LAST: {
                        return Stream.of(String.format("(CASE WHEN %s IS NULL THEN 1 ELSE 0 END) ASC", this.quoted(sortItem.getName())), columnSorting);
                    }
                    case DESC_NULLS_FIRST: {
                        return Stream.of(String.format("(CASE WHEN %s IS NULL THEN 1 ELSE 0 END) DESC", this.quoted(sortItem.getName())), columnSorting);
                    }
                }
                throw new UnsupportedOperationException("Unsupported sort order: " + sortItem.getSortOrder());
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s OFFSET 0 ROWS FETCH NEXT %s ROWS ONLY", query, orderBy, limit);
        });
    }

    public boolean isTopNLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    protected boolean isSupportedJoinCondition(JdbcJoinCondition joinCondition) {
        if (joinCondition.getOperator() == JoinCondition.Operator.IS_DISTINCT_FROM) {
            return false;
        }
        return Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).noneMatch(type -> type instanceof CharType || type instanceof VarcharType);
    }

    protected String createTableSql(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        return String.format("CREATE TABLE %s (%s) %s", this.quoted(remoteTableName), String.join((CharSequence)", ", columns), SqlServerTableProperties.getDataCompression(tableMetadata.getProperties()).map(dataCompression -> String.format("WITH (DATA_COMPRESSION = %s)", dataCompression)).orElse(""));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getTableProperties(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (!tableHandle.isNamedRelation()) {
            return ImmutableMap.of();
        }
        try (Connection connection = this.configureConnectionTransactionIsolation(this.connectionFactory.openConnection(session));){
            Map map;
            block15: {
                Handle handle = Jdbi.open((Connection)connection);
                try {
                    map = (Map)SqlServerClient.getTableDataCompression(handle, tableHandle).map(dataCompression -> ImmutableMap.of((Object)"data_compression", (Object)dataCompression)).orElseGet(ImmutableMap::of);
                    if (handle == null) break block15;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return map;
        }
        catch (SQLException exception) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)exception);
        }
    }

    public void abortReadConnection(Connection connection) throws SQLException {
        connection.abort(MoreExecutors.directExecutor());
    }

    public Connection getConnection(ConnectorSession session, JdbcOutputTableHandle handle) throws SQLException {
        return this.configureConnectionTransactionIsolation(super.getConnection(session, handle));
    }

    public Connection getConnection(ConnectorSession session, JdbcSplit split) throws SQLException {
        return this.configureConnectionTransactionIsolation(super.getConnection(session, split));
    }

    private Connection configureConnectionTransactionIsolation(Connection connection) throws SQLException {
        try {
            if (this.hasSnapshotIsolationEnabled(connection)) {
                connection.setTransactionIsolation(4096);
            }
        }
        catch (SQLException e) {
            connection.close();
            throw e;
        }
        return connection;
    }

    private boolean hasSnapshotIsolationEnabled(Connection connection) throws SQLException {
        try {
            return (Boolean)this.snapshotIsolationEnabled.get((Object)SnapshotIsolationEnabledCacheKey.INSTANCE, () -> {
                Handle handle = Jdbi.open((Connection)connection);
                return ((Query)handle.createQuery("SELECT is_read_committed_snapshot_on FROM sys.databases WHERE name = :name").bind("name", connection.getCatalog())).mapTo(Boolean.class).findOne().orElse(false);
            });
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, (Throwable)e);
        }
    }

    private static String singleQuote(String ... objects) {
        return SqlServerClient.singleQuote(DOT_JOINER.join((Object[])objects));
    }

    private static String singleQuote(String literal) {
        return "'" + literal + "'";
    }

    public static ColumnMapping varbinaryColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarbinaryType.VARBINARY, (resultSet, columnIndex) -> Slices.wrappedBuffer((byte[])resultSet.getBytes(columnIndex)), (SliceWriteFunction)SqlServerClient.varbinaryWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static SliceWriteFunction varbinaryWriteFunction() {
        return new SliceWriteFunction(){

            public void set(PreparedStatement statement, int index, Slice value) throws SQLException {
                statement.setBytes(index, value.getBytes());
            }

            public void setNull(PreparedStatement statement, int index) throws SQLException {
                statement.setBytes(index, null);
            }
        };
    }

    private static Optional<DataCompression> getTableDataCompression(Handle handle, JdbcTableHandle table) {
        return ((Query)((Query)handle.createQuery("SELECT data_compression_desc FROM sys.partitions p INNER JOIN sys.tables t ON p.object_id = t.object_id INNER JOIN sys.schemas s ON t.schema_id = s.schema_id INNER JOIN sys.indexes i ON t.object_id = i.object_id WHERE s.name = :schema AND t.name = :table_name AND p.index_id = 0 AND i.type = 0 AND i.data_space_id NOT IN (SELECT data_space_id FROM sys.partition_schemes)").bind("schema", table.getSchemaName())).bind("table_name", table.getTableName())).mapTo(String.class).findOne().flatMap(dataCompression -> Enums.getIfPresent(DataCompression.class, (String)dataCompression).toJavaUtil());
    }

    private static enum SnapshotIsolationEnabledCacheKey {
        INSTANCE;

    }
}

