/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.common.base.MoreObjects;
import com.google.common.base.StandardSystemProperty;
import com.google.common.base.Strings;
import com.google.common.primitives.Ints;
import io.trino.server.Server;

public final class TrinoServer {
    private TrinoServer() {
    }

    public static void main(String[] args) {
        String javaVersion = Strings.nullToEmpty((String)StandardSystemProperty.JAVA_VERSION.value());
        String majorVersion = javaVersion.split("[^\\d]", 2)[0];
        Integer major = Ints.tryParse((String)majorVersion);
        if (major == null || major < 17) {
            System.err.println(String.format("ERROR: Trino requires Java 17+ (found %s)", javaVersion));
            System.exit(100);
        }
        String version = TrinoServer.class.getPackage().getImplementationVersion();
        new Server().start((String)MoreObjects.firstNonNull((Object)version, (Object)"unknown"));
    }
}

