/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import io.trino.decoder.avro.AvroDeserializer;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class AvroBytesDeserializer<T>
implements AvroDeserializer<T> {
    public static final String NAME = "bytes";
    private static final ThreadLocal<BinaryDecoder> reuseDecoder = ThreadLocal.withInitial(() -> null);
    private final AvroReaderSupplier<T> avroReaderSupplier;

    public AvroBytesDeserializer(AvroReaderSupplier<T> avroReaderSupplier) {
        this.avroReaderSupplier = Objects.requireNonNull(avroReaderSupplier, "avroReaderSupplier is null");
    }

    @Override
    public T deserialize(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        DatumReader<T> avroReader = this.avroReaderSupplier.get(buffer);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, buffer.position(), data.length - buffer.position(), reuseDecoder.get());
        reuseDecoder.set(decoder);
        try {
            return (T)avroReader.read(null, (Decoder)decoder);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Decoding Avro record failed.", (Throwable)e);
        }
    }

    public static class Factory
    implements AvroDeserializer.Factory {
        @Override
        public <T> AvroDeserializer<T> create(AvroReaderSupplier<T> avroReaderSupplier) {
            return new AvroBytesDeserializer<T>(avroReaderSupplier);
        }
    }
}

