/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.ImmutableSet;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.json.JsonFieldDecoder;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ISO8601JsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)DateType.DATE, (Object)TimeType.TIME_MILLIS, (Object)TimeWithTimeZoneType.TIME_TZ_MILLIS, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    private final DecoderColumnHandle columnHandle;

    public ISO8601JsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new ISO8601JsonValueProvider(value, this.columnHandle);
    }

    private static class ISO8601JsonValueProvider
    extends FieldValueProvider {
        private final JsonNode value;
        private final DecoderColumnHandle columnHandle;

        public ISO8601JsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
            this.value = value;
            this.columnHandle = columnHandle;
        }

        @Override
        public boolean isNull() {
            return this.value.isMissingNode() || this.value.isNull();
        }

        @Override
        public long getLong() {
            Type columnType = this.columnHandle.getType();
            if (!this.value.isValueNode()) {
                throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", columnType, this.columnHandle.getName()));
            }
            try {
                String textValue = this.value.asText();
                if (columnType.equals((Object)TimestampType.TIMESTAMP_MILLIS)) {
                    try {
                        TemporalAccessor parseResult = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(textValue);
                        return TimeUnit.DAYS.toMicros(parseResult.getLong(ChronoField.EPOCH_DAY)) + parseResult.getLong(ChronoField.MICRO_OF_DAY);
                    }
                    catch (DateTimeParseException e) {
                        TemporalAccessor parseResult = DateTimeFormatter.ISO_DATE_TIME.parse(textValue);
                        return TimeUnit.DAYS.toMicros(parseResult.getLong(ChronoField.EPOCH_DAY)) + parseResult.getLong(ChronoField.MICRO_OF_DAY);
                    }
                }
                if (columnType.equals((Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
                    TemporalAccessor parseResult = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(textValue);
                    return DateTimeEncoding.packDateTimeWithZone((long)(parseResult.getLong(ChronoField.INSTANT_SECONDS) * 1000L + parseResult.getLong(ChronoField.MILLI_OF_SECOND)), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)ZoneId.from(parseResult).getId()));
                }
                if (columnType.equals((Object)TimeType.TIME_MILLIS)) {
                    return DateTimeFormatter.ISO_TIME.parse(textValue).getLong(ChronoField.MILLI_OF_DAY) * 1000000000L;
                }
                if (columnType.equals((Object)TimeWithTimeZoneType.TIME_TZ_MILLIS)) {
                    TemporalAccessor parseResult = DateTimeFormatter.ISO_OFFSET_TIME.parse(textValue);
                    return DateTimeEncoding.packTimeWithTimeZone((long)((long)parseResult.get(ChronoField.MILLI_OF_DAY) * 1000000L), (int)(ZoneOffset.from(parseResult).getTotalSeconds() / 60));
                }
                if (columnType == DateType.DATE) {
                    return DateTimeFormatter.ISO_DATE.parse(textValue).getLong(ChronoField.EPOCH_DAY);
                }
                throw new IllegalArgumentException("unsupported type " + String.valueOf(columnType));
            }
            catch (DateTimeParseException e) {
                throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), columnType, this.columnHandle.getName()));
            }
        }
    }
}

