/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class ProtobufValueProvider
extends FieldValueProvider {
    @Nullable
    private final Object value;
    private final Type columnType;
    private final String columnName;
    private final Type jsonType;

    public ProtobufValueProvider(@Nullable Object value, Type columnType, String columnName, TypeManager typeManager) {
        this.value = value;
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public double getDouble() {
        Objects.requireNonNull(this.value, "value is null");
        if (this.value instanceof Double || this.value instanceof Float) {
            return ((Number)this.value).doubleValue();
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
    }

    @Override
    public boolean getBoolean() {
        Objects.requireNonNull(this.value, "value is null");
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
    }

    @Override
    public long getLong() {
        Objects.requireNonNull(this.value, "value is null");
        if (this.value instanceof Long || this.value instanceof Integer) {
            return ((Number)this.value).longValue();
        }
        if (this.value instanceof Float) {
            return Float.floatToIntBits(((Float)this.value).floatValue());
        }
        if (this.value instanceof DynamicMessage) {
            Preconditions.checkArgument((boolean)(this.columnType instanceof TimestampType), (Object)"type should be an instance of Timestamp");
            return ProtobufValueProvider.parseTimestamp(((TimestampType)this.columnType).getPrecision(), (DynamicMessage)this.value);
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
    }

    @Override
    public Slice getSlice() {
        return this.getSlice(this.value, this.columnType, this.columnName);
    }

    @Override
    public Block getBlock() {
        return this.serializeObject(null, this.value, this.columnType, this.columnName);
    }

    private Slice getSlice(Object value, Type type, String columnName) {
        Objects.requireNonNull(value, "value is null");
        if (type instanceof VarcharType && value instanceof CharSequence || value instanceof Descriptors.EnumValueDescriptor) {
            return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value.toString()), (Type)type);
        }
        if (type instanceof VarbinaryType && value instanceof ByteString) {
            return Slices.wrappedBuffer((byte[])((ByteString)value).toByteArray());
        }
        if (type.equals(this.jsonType)) {
            return (Slice)value;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    @Nullable
    private Block serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
        if (type instanceof ArrayType) {
            return this.serializeList(builder, value, type, columnName);
        }
        if (type instanceof MapType) {
            return this.serializeMap(builder, value, type, columnName);
        }
        if (type instanceof RowType) {
            return this.serializeRow(builder, value, type, columnName);
        }
        if (type.equals(this.jsonType)) {
            return ProtobufValueProvider.serializeJson(builder, value, type);
        }
        this.serializePrimitive(builder, value, type, columnName);
        return null;
    }

    @Nullable
    private Block serializeList(BlockBuilder parentBlockBuilder, @Nullable Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        List list = (List)value;
        List typeParameters = type.getTypeParameters();
        Type elementType = (Type)typeParameters.get(0);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            this.serializeObject(blockBuilder, element, elementType, columnName);
        }
        if (parentBlockBuilder != null) {
            type.writeObject(parentBlockBuilder, (Object)blockBuilder.build());
            return null;
        }
        return blockBuilder.build();
    }

    private void serializePrimitive(BlockBuilder blockBuilder, @Nullable Object value, Type type, String columnName) {
        Objects.requireNonNull(blockBuilder, "parent blockBuilder is null");
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof BooleanType) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
            return;
        }
        if ((value instanceof Integer || value instanceof Long) && (type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
            return;
        }
        if (type instanceof DoubleType && value instanceof Double) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
            return;
        }
        if (type instanceof RealType && value instanceof Float) {
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(((Float)value).floatValue()));
            return;
        }
        if (type instanceof VarcharType || type instanceof VarbinaryType) {
            type.writeSlice(blockBuilder, this.getSlice(value, type, columnName));
            return;
        }
        if (type instanceof TimestampType && ((TimestampType)type).isShort()) {
            Preconditions.checkArgument((boolean)(value instanceof DynamicMessage), (Object)"value should be an instance of DynamicMessage");
            type.writeLong(blockBuilder, ProtobufValueProvider.parseTimestamp(((TimestampType)type).getPrecision(), (DynamicMessage)value));
            return;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    @Nullable
    private Block serializeMap(BlockBuilder parentBlockBuilder, @Nullable Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        Collection dynamicMessages = (Collection)((Collection)value).stream().map(DynamicMessage.class::cast).collect(ImmutableList.toImmutableList());
        List typeParameters = type.getTypeParameters();
        Type keyType = (Type)typeParameters.get(0);
        Type valueType = (Type)typeParameters.get(1);
        BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        for (DynamicMessage dynamicMessage : dynamicMessages) {
            if (dynamicMessage.getField(dynamicMessage.getDescriptorForType().findFieldByNumber(1)) == null) continue;
            this.serializeObject(entryBuilder, dynamicMessage.getField(ProtobufValueProvider.getFieldDescriptor(dynamicMessage, 1)), keyType, columnName);
            this.serializeObject(entryBuilder, dynamicMessage.getField(ProtobufValueProvider.getFieldDescriptor(dynamicMessage, 2)), valueType, columnName);
        }
        blockBuilder.closeEntry();
        if (parentBlockBuilder == null) {
            return (Block)blockBuilder.getObject(0, Block.class);
        }
        return null;
    }

    @Nullable
    private Block serializeRow(BlockBuilder parentBlockBuilder, @Nullable Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parent block builder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
        BlockBuilder singleRowBuilder = blockBuilder.beginBlockEntry();
        DynamicMessage record = (DynamicMessage)value;
        List fields = ((RowType)type).getFields();
        for (RowType.Field field : fields) {
            Preconditions.checkState((boolean)field.getName().isPresent(), (Object)"field name not found");
            Descriptors.FieldDescriptor fieldDescriptor = ProtobufValueProvider.getFieldDescriptor(record, (String)field.getName().get());
            Preconditions.checkState((fieldDescriptor != null ? 1 : 0) != 0, (Object)String.format("Unknown Field %s", field.getName().get()));
            this.serializeObject(singleRowBuilder, record.getField(fieldDescriptor), field.getType(), columnName);
        }
        blockBuilder.closeEntry();
        if (parentBlockBuilder == null) {
            return (Block)blockBuilder.getObject(0, Block.class);
        }
        return null;
    }

    @Nullable
    private static Block serializeJson(BlockBuilder builder, Object value, Type type) {
        if (builder != null) {
            type.writeObject(builder, value);
            return null;
        }
        return (Block)value;
    }

    private static long parseTimestamp(int precision, DynamicMessage timestamp) {
        long seconds = (Long)timestamp.getField(timestamp.getDescriptorForType().findFieldByName("seconds"));
        int nanos = (Integer)timestamp.getField(timestamp.getDescriptorForType().findFieldByName("nanos"));
        long micros = seconds * 1000000L;
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (Object)"precision must be less than max short timestamp precision (6)");
        return Timestamps.round((long)(micros += (long)Timestamps.roundDiv((int)nanos, (long)1000L)), (int)(6 - precision));
    }

    private static Descriptors.FieldDescriptor getFieldDescriptor(DynamicMessage message, String name) {
        return message.getDescriptorForType().findFieldByName(name);
    }

    private static Descriptors.FieldDescriptor getFieldDescriptor(DynamicMessage message, int index) {
        return message.getDescriptorForType().findFieldByNumber(index);
    }
}

