/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.time.Instant;
import java.util.concurrent.TimeUnit;

public abstract class AbstractDateTimeJsonValueProvider
extends FieldValueProvider {
    protected final JsonNode value;
    protected final DecoderColumnHandle columnHandle;

    protected AbstractDateTimeJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle) {
        this.value = value;
        this.columnHandle = columnHandle;
    }

    @Override
    public final boolean isNull() {
        return this.value.isMissingNode() || this.value.isNull();
    }

    @Override
    public final long getLong() {
        long millis = this.getMillis();
        Type type = this.columnHandle.getType();
        if ((type.equals(TimeType.TIME_MILLIS) || type.equals(TimeWithTimeZoneType.TIME_TZ_MILLIS)) && (millis < 0L || millis >= TimeUnit.DAYS.toMillis(1L))) {
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
        }
        if (type.equals(DateType.DATE)) {
            return TimeUnit.MILLISECONDS.toDays(millis);
        }
        if (type.equals(TimeType.TIME_MILLIS)) {
            return millis * 1000000000L;
        }
        if (type.equals(TimestampType.TIMESTAMP_MILLIS)) {
            return millis * 1000L;
        }
        if (type.equals(TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            return DateTimeEncoding.packDateTimeWithZone((long)millis, (TimeZoneKey)this.getTimeZone());
        }
        if (type.equals(TimeWithTimeZoneType.TIME_TZ_MILLIS)) {
            int offsetMinutes = this.getTimeZone().getZoneId().getRules().getOffset(Instant.ofEpochMilli(millis)).getTotalSeconds() / 60;
            return DateTimeEncoding.packTimeWithTimeZone((long)((millis + (long)(offsetMinutes * 60 * 1000)) * 1000000L), (int)offsetMinutes);
        }
        throw new IllegalStateException("Unsupported type: " + type);
    }

    protected abstract long getMillis();

    protected abstract TimeZoneKey getTimeZone();
}

