/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.json.AbstractDateTimeJsonValueProvider;
import io.trino.decoder.json.JsonFieldDecoder;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class CustomDateTimeJsonFieldDecoder
implements JsonFieldDecoder {
    private static final Set<Type> SUPPORTED_TYPES = ImmutableSet.of((Object)DateType.DATE, (Object)TimeType.TIME_MILLIS, (Object)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, (Object)TimestampType.TIMESTAMP_MILLIS, (Object)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    private final DecoderColumnHandle columnHandle;
    private final DateTimeFormatter formatter;

    public CustomDateTimeJsonFieldDecoder(DecoderColumnHandle columnHandle) {
        this.columnHandle = Objects.requireNonNull(columnHandle, "columnHandle is null");
        if (!SUPPORTED_TYPES.contains(columnHandle.getType())) {
            JsonRowDecoderFactory.throwUnsupportedColumnType(columnHandle);
        }
        Preconditions.checkArgument((columnHandle.getFormatHint() != null ? 1 : 0) != 0, (String)"format hint not defined for column '%s'", (Object)columnHandle.getName());
        try {
            this.formatter = DateTimeFormat.forPattern((String)columnHandle.getFormatHint()).withLocale(Locale.ENGLISH).withChronology((Chronology)ISOChronology.getInstanceUTC()).withOffsetParsed();
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, String.format("invalid Joda Time pattern '%s' passed as format hint for column '%s'", columnHandle.getFormatHint(), columnHandle.getName()));
        }
    }

    @Override
    public FieldValueProvider decode(JsonNode value) {
        return new CustomDateTimeJsonValueProvider(value, this.columnHandle, this.formatter);
    }

    public static class CustomDateTimeJsonValueProvider
    extends AbstractDateTimeJsonValueProvider {
        private final DateTimeFormatter formatter;

        public CustomDateTimeJsonValueProvider(JsonNode value, DecoderColumnHandle columnHandle, DateTimeFormatter formatter) {
            super(value, columnHandle);
            this.formatter = formatter;
        }

        @Override
        protected long getMillis() {
            if (!this.value.isValueNode()) {
                throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
            }
            try {
                return this.formatter.parseMillis(this.value.asText());
            }
            catch (IllegalArgumentException e) {
                throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
            }
        }

        @Override
        protected TimeZoneKey getTimeZone() {
            if (this.value.isValueNode()) {
                try {
                    return TimeZoneKey.getTimeZoneKey((String)this.formatter.parseDateTime(this.value.asText()).getZone().getID());
                }
                catch (IllegalArgumentException e) {
                    throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse value '%s' as '%s' for column '%s'", this.value.asText(), this.columnHandle.getType(), this.columnHandle.getName()));
                }
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("could not parse non-value node as '%s' for column '%s'", this.columnHandle.getType(), this.columnHandle.getName()));
        }
    }
}

