/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.base.Suppliers;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.json.JsonCodec;
import io.trino.plugin.prometheus.PrometheusColumn;
import io.trino.plugin.prometheus.PrometheusConnectorConfig;
import io.trino.plugin.prometheus.PrometheusErrorCode;
import io.trino.plugin.prometheus.PrometheusTable;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class PrometheusClient {
    static final Type TIMESTAMP_COLUMN_TYPE = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3);
    static final String METRICS_ENDPOINT = "/api/v1/label/__name__/values";
    private final OkHttpClient httpClient;
    private final Supplier<Map<String, Object>> tableSupplier;
    private final Type varcharMapType;
    private final boolean caseInsensitiveNameMatching;

    @Inject
    public PrometheusClient(PrometheusConnectorConfig config, JsonCodec<Map<String, Object>> metricCodec, TypeManager typeManager) {
        Objects.requireNonNull(metricCodec, "metricCodec is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().readTimeout(Duration.ofMillis(config.getReadTimeout().toMillis()));
        PrometheusClient.setupBasicAuth(clientBuilder, config.getUser(), config.getPassword());
        PrometheusClient.setupTokenAuth(clientBuilder, this.getBearerAuthInfoFromFile(config.getBearerTokenFile()));
        this.httpClient = clientBuilder.build();
        URI prometheusMetricsUri = PrometheusClient.getPrometheusMetricsURI(config.getPrometheusURI());
        this.tableSupplier = Suppliers.memoizeWithExpiration(() -> this.fetchMetrics(metricCodec, prometheusMetricsUri), (long)config.getCacheDuration().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.varcharMapType = typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        this.caseInsensitiveNameMatching = config.isCaseInsensitiveNameMatching();
    }

    private static URI getPrometheusMetricsURI(URI prometheusUri) {
        return HttpUriBuilder.uriBuilderFrom((URI)prometheusUri).appendPath(METRICS_ENDPOINT).build();
    }

    public Set<String> getTableNames(String schema) {
        Objects.requireNonNull(schema, "schema is null");
        String status = "";
        if (schema.equals("default") && (status = (String)this.tableSupplier.get().get("status")).equals("success")) {
            List tableNames = (List)this.tableSupplier.get().get("data");
            if (tableNames == null) {
                return ImmutableSet.of();
            }
            return ImmutableSet.copyOf((Collection)tableNames);
        }
        throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_TABLES_METRICS_RETRIEVE_ERROR, "Prometheus did no return metrics list (table names): " + status);
    }

    @Nullable
    public PrometheusTable getTable(String schema, String tableName) {
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(tableName, "tableName is null");
        if (!schema.equals("default")) {
            return null;
        }
        String remoteTableName = this.toRemoteTableName(tableName);
        if (remoteTableName == null) {
            return null;
        }
        return new PrometheusTable(remoteTableName, (List<PrometheusColumn>)ImmutableList.of((Object)new PrometheusColumn("labels", this.varcharMapType), (Object)new PrometheusColumn("timestamp", TIMESTAMP_COLUMN_TYPE), (Object)new PrometheusColumn("value", (Type)DoubleType.DOUBLE)));
    }

    @Nullable
    private String toRemoteTableName(String tableName) {
        Verify.verify((boolean)tableName.equals(tableName.toLowerCase(Locale.ENGLISH)), (String)"tableName not in lower-case: %s", (Object)tableName);
        List tableNames = (List)this.tableSupplier.get().get("data");
        if (tableNames == null) {
            return null;
        }
        if (!this.caseInsensitiveNameMatching) {
            if (tableNames.contains(tableName)) {
                return tableName;
            }
        } else {
            for (String remoteTableName : tableNames) {
                if (!tableName.equals(remoteTableName.toLowerCase(Locale.ENGLISH))) continue;
                return remoteTableName;
            }
        }
        return null;
    }

    private Map<String, Object> fetchMetrics(JsonCodec<Map<String, Object>> metricsCodec, URI metadataUri) {
        return (Map)metricsCodec.fromJson(this.fetchUri(metadataUri));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] fetchUri(URI uri) {
        Request.Builder requestBuilder = new Request.Builder().url(uri.toString());
        try (Response response = this.httpClient.newCall(requestBuilder.build()).execute();){
            if (!response.isSuccessful()) throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Bad response " + response.code() + " " + response.message());
            if (response.body() == null) throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Bad response " + response.code() + " " + response.message());
            byte[] byArray = response.body().bytes();
            return byArray;
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Error reading metrics", (Throwable)e);
        }
    }

    private Optional<String> getBearerAuthInfoFromFile(Optional<File> bearerTokenFile) {
        return bearerTokenFile.map(tokenFileName -> {
            try {
                return Files.readString(tokenFileName.toPath(), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "Failed to read bearer token file: " + String.valueOf(tokenFileName), (Throwable)e);
            }
        });
    }

    private static void setupBasicAuth(OkHttpClient.Builder clientBuilder, Optional<String> user, Optional<String> password) {
        if (user.isPresent() && password.isPresent()) {
            clientBuilder.addInterceptor(PrometheusClient.basicAuth(user.get(), password.get()));
        }
    }

    private static void setupTokenAuth(OkHttpClient.Builder clientBuilder, Optional<String> accessToken) {
        accessToken.ifPresent(token -> clientBuilder.addInterceptor(PrometheusClient.tokenAuth(token)));
    }

    private static Interceptor basicAuth(String user, String password) {
        Objects.requireNonNull(user, "user is null");
        Objects.requireNonNull(password, "password is null");
        if (user.contains(":")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, "Illegal character ':' found in username");
        }
        String credential = Credentials.basic((String)user, (String)password);
        return chain -> chain.proceed(chain.request().newBuilder().header("Authorization", credential).build());
    }

    private static Interceptor tokenAuth(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken is null");
        return chain -> chain.proceed(chain.request().newBuilder().addHeader("Authorization", "Bearer " + accessToken).build());
    }
}

