/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.plugin.prometheus.PrometheusClient;
import io.trino.plugin.prometheus.PrometheusColumnHandle;
import io.trino.plugin.prometheus.PrometheusTable;
import io.trino.plugin.prometheus.PrometheusTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PrometheusMetadata
implements ConnectorMetadata {
    private final PrometheusClient prometheusClient;

    @Inject
    public PrometheusMetadata(PrometheusClient prometheusClient) {
        this.prometheusClient = Objects.requireNonNull(prometheusClient, "prometheusClient is null");
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return PrometheusMetadata.listSchemaNames();
    }

    private static List<String> listSchemaNames() {
        return ImmutableList.copyOf((Collection)ImmutableSet.of((Object)"default"));
    }

    public PrometheusTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (!this.listSchemaNames(session).contains(tableName.getSchemaName())) {
            return null;
        }
        if (this.prometheusClient.getTable(tableName.getSchemaName(), tableName.getTableName()) == null) {
            return null;
        }
        return new PrometheusTableHandle(tableName.getSchemaName(), tableName.getTableName());
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        return this.getTableMetadata(((PrometheusTableHandle)table).toSchemaTableName());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> optionalSchemaName) {
        Set schemaNames = (Set)optionalSchemaName.map(ImmutableSet::of).orElseGet(() -> ImmutableSet.copyOf((Collection)ImmutableSet.of((Object)"default")));
        return (List)schemaNames.stream().flatMap(schemaName -> this.prometheusClient.getTableNames((String)schemaName).stream().map(tableName -> new SchemaTableName(schemaName, tableName))).collect(ImmutableList.toImmutableList());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PrometheusTableHandle prometheusTableHandle = (PrometheusTableHandle)tableHandle;
        PrometheusTable table = this.prometheusClient.getTable(prometheusTableHandle.getSchemaName(), prometheusTableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(prometheusTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        for (ColumnMetadata column : table.getColumnsMetadata()) {
            columnHandles.put((Object)column.getName(), (Object)new PrometheusColumnHandle(column.getName(), column.getType(), index));
            ++index;
        }
        return columnHandles.buildOrThrow();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.buildOrThrow();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        if (!PrometheusMetadata.listSchemaNames().contains(tableName.getSchemaName())) {
            return null;
        }
        PrometheusTable table = this.prometheusClient.getTable(tableName.getSchemaName(), tableName.getTableName());
        if (table == null) {
            return null;
        }
        return new ConnectorTableMetadata(tableName, table.getColumnsMetadata());
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getTable().isEmpty()) {
            return this.listTables(session, prefix.getSchema());
        }
        return ImmutableList.of((Object)prefix.toSchemaTableName());
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((PrometheusColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle handle, Constraint constraint) {
        PrometheusTableHandle tableHandle = ((PrometheusTableHandle)handle).withPredicate((TupleDomain<ColumnHandle>)constraint.getSummary());
        return Optional.of(new ConstraintApplicationResult((Object)tableHandle, constraint.getSummary(), false));
    }
}

