/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import io.trino.plugin.prometheus.PrometheusClient;
import io.trino.plugin.prometheus.PrometheusColumnHandle;
import io.trino.plugin.prometheus.PrometheusRecordCursor;
import io.trino.plugin.prometheus.PrometheusSplit;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.RecordSet;
import io.trino.spi.type.Type;
import java.net.URI;
import java.util.List;
import java.util.Objects;

public class PrometheusRecordSet
implements RecordSet {
    private final List<PrometheusColumnHandle> columnHandles;
    private final List<Type> columnTypes;
    private final ByteSource byteSource;

    public PrometheusRecordSet(PrometheusClient prometheusClient, PrometheusSplit split, List<PrometheusColumnHandle> columnHandles) {
        Objects.requireNonNull(prometheusClient, "prometheusClient is null");
        Objects.requireNonNull(split, "split is null");
        this.columnHandles = Objects.requireNonNull(columnHandles, "columnHandles is null");
        ImmutableList.Builder types = ImmutableList.builder();
        for (PrometheusColumnHandle column : columnHandles) {
            types.add((Object)column.getColumnType());
        }
        this.columnTypes = types.build();
        this.byteSource = ByteSource.wrap((byte[])prometheusClient.fetchUri(URI.create(split.getUri())));
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new PrometheusRecordCursor(this.columnHandles, this.byteSource);
    }
}

