/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.base.Throwables;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.trino.plugin.base.TypeDeserializerModule;
import io.trino.plugin.base.Versions;
import io.trino.plugin.prometheus.PrometheusConnector;
import io.trino.plugin.prometheus.PrometheusModule;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import java.util.Map;
import java.util.Objects;

public class PrometheusConnectorFactory
implements ConnectorFactory {
    public String getName() {
        return "prometheus";
    }

    public Connector create(String catalogName, Map<String, String> requiredConfig, ConnectorContext context) {
        Objects.requireNonNull(requiredConfig, "requiredConfig is null");
        Versions.checkSpiVersion((ConnectorContext)context, (ConnectorFactory)this);
        try {
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new TypeDeserializerModule(context.getTypeManager()), new PrometheusModule()});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(requiredConfig).initialize();
            return (Connector)injector.getInstance(PrometheusConnector.class);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

