/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.units.Duration;
import io.trino.plugin.prometheus.PrometheusClient;
import io.trino.plugin.prometheus.PrometheusClock;
import io.trino.plugin.prometheus.PrometheusColumnHandle;
import io.trino.plugin.prometheus.PrometheusConnectorConfig;
import io.trino.plugin.prometheus.PrometheusErrorCode;
import io.trino.plugin.prometheus.PrometheusPredicateTimeInfo;
import io.trino.plugin.prometheus.PrometheusSplit;
import io.trino.plugin.prometheus.PrometheusTable;
import io.trino.plugin.prometheus.PrometheusTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.DateTimeEncoding;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.inject.Inject;

public class PrometheusSplitManager
implements ConnectorSplitManager {
    static final long OFFSET_MILLIS = 1L;
    private final PrometheusClient prometheusClient;
    private final PrometheusClock prometheusClock;
    private final URI prometheusURI;
    private final Duration maxQueryRangeDuration;
    private final Duration queryChunkSizeDuration;

    @Inject
    public PrometheusSplitManager(PrometheusClient prometheusClient, PrometheusClock prometheusClock, PrometheusConnectorConfig config) {
        this.prometheusClient = Objects.requireNonNull(prometheusClient, "prometheusClient is null");
        this.prometheusClock = Objects.requireNonNull(prometheusClock, "prometheusClock is null");
        this.prometheusURI = config.getPrometheusURI();
        this.maxQueryRangeDuration = config.getMaxQueryRangeDuration();
        this.queryChunkSizeDuration = config.getQueryChunkSizeDuration();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle connectorTableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        PrometheusTableHandle tableHandle = (PrometheusTableHandle)connectorTableHandle;
        PrometheusTable table = this.prometheusClient.getTable(tableHandle.getSchemaName(), tableHandle.getTableName());
        if (table == null) {
            throw new TableNotFoundException(tableHandle.toSchemaTableName());
        }
        List splits = PrometheusSplitManager.generateTimesForSplits(this.prometheusClock.now(), this.maxQueryRangeDuration, this.queryChunkSizeDuration, tableHandle).stream().map(time -> {
            try {
                return new PrometheusSplit(PrometheusSplitManager.buildQuery(this.prometheusURI, time, table.getName(), this.queryChunkSizeDuration).toString());
            }
            catch (URISyntaxException e) {
                throw new TrinoException((ErrorCodeSupplier)PrometheusErrorCode.PROMETHEUS_UNKNOWN_ERROR, "split URI invalid: " + e.getMessage());
            }
        }).collect(Collectors.toList());
        return new FixedSplitSource(splits);
    }

    private static URI buildQuery(URI baseURI, String time, String metricName, Duration queryChunkSizeDuration) throws URISyntaxException {
        return HttpUriBuilder.uriBuilderFrom((URI)baseURI).appendPath("api/v1/query").addParameter("query", new String[]{metricName + "[" + queryChunkSizeDuration.roundTo(queryChunkSizeDuration.getUnit()) + Duration.timeUnitToString((TimeUnit)queryChunkSizeDuration.getUnit()) + "]"}).addParameter("time", new String[]{time}).build();
    }

    protected static List<String> generateTimesForSplits(Instant defaultUpperBound, Duration maxQueryRangeDurationRequested, Duration queryChunkSizeDurationRequested, PrometheusTableHandle tableHandle) {
        Optional<PrometheusPredicateTimeInfo> predicateRange = tableHandle.getPredicate().flatMap(PrometheusSplitManager::determinePredicateTimes);
        EffectiveLimits effectiveLimits = new EffectiveLimits(defaultUpperBound, maxQueryRangeDurationRequested, predicateRange);
        Instant upperBound = effectiveLimits.getUpperBound();
        java.time.Duration maxQueryRangeDuration = effectiveLimits.getMaxQueryRangeDuration();
        java.time.Duration queryChunkSizeDuration = java.time.Duration.ofMillis(queryChunkSizeDurationRequested.toMillis());
        if (maxQueryRangeDuration.isNegative()) {
            throw new IllegalArgumentException("prometheus.max.query.range.duration may not be negative");
        }
        if (queryChunkSizeDuration.isNegative()) {
            throw new IllegalArgumentException("prometheus.query.chunk.size.duration may not be negative");
        }
        if (queryChunkSizeDuration.isZero()) {
            throw new IllegalArgumentException("prometheus.query.chunk.size.duration may not be zero");
        }
        BigDecimal maxQueryRangeDecimal = BigDecimal.valueOf(maxQueryRangeDuration.getSeconds()).add(BigDecimal.valueOf(maxQueryRangeDuration.getNano(), 9));
        BigDecimal queryChunkSizeDecimal = BigDecimal.valueOf(queryChunkSizeDuration.getSeconds()).add(BigDecimal.valueOf(queryChunkSizeDuration.getNano(), 9));
        int numChunks = maxQueryRangeDecimal.divide(queryChunkSizeDecimal, 0, RoundingMode.UP).intValue();
        return Lists.reverse(IntStream.range(0, numChunks).mapToObj(n -> {
            long endTime = upperBound.toEpochMilli() - (long)n * queryChunkSizeDuration.toMillis() - (long)n * 1L;
            return endTime;
        }).map(PrometheusSplitManager::decimalSecondString).collect(Collectors.toList()));
    }

    protected static Optional<PrometheusPredicateTimeInfo> determinePredicateTimes(TupleDomain<ColumnHandle> predicate) {
        Optional maybeColumnHandleDomainMap = predicate.getDomains();
        Optional<Set> maybeKeySet = maybeColumnHandleDomainMap.map(Map::keySet);
        Optional<Set> maybeOnlyPromColHandles = maybeKeySet.map(keySet -> keySet.stream().filter(PrometheusColumnHandle.class::isInstance).collect(Collectors.toSet()));
        Optional<Set> maybeOnlyTimeStampColumnHandles = maybeOnlyPromColHandles.map(handles -> handles.stream().map(PrometheusColumnHandle.class::cast).filter(handle -> handle.getColumnType().equals(PrometheusClient.TIMESTAMP_COLUMN_TYPE)).filter(handle -> handle.getColumnName().equals("timestamp")).collect(Collectors.toSet()));
        Map columnHandleDomainMap = (Map)maybeColumnHandleDomainMap.orElse(ImmutableMap.of());
        Optional<Set<Domain>> maybeTimeDomains = maybeOnlyTimeStampColumnHandles.map(columnHandles -> columnHandles.stream().map(columnHandleDomainMap::get).collect(Collectors.toSet()));
        return PrometheusSplitManager.processTimeDomains(maybeTimeDomains);
    }

    private static Optional<PrometheusPredicateTimeInfo> processTimeDomains(Optional<Set<Domain>> maybeTimeDomains) {
        return maybeTimeDomains.map(timeDomains -> {
            PrometheusPredicateTimeInfo.Builder timeInfoBuilder = PrometheusPredicateTimeInfo.builder();
            timeDomains.forEach(domain -> {
                Instant instant;
                long packedValue;
                Range span = domain.getValues().getRanges().getSpan();
                if (!span.isLowUnbounded()) {
                    packedValue = (Long)span.getLowBoundedValue();
                    instant = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)packedValue));
                    timeInfoBuilder.setPredicateLowerTimeBound(Optional.of(instant));
                }
                if (!span.isHighUnbounded()) {
                    packedValue = (Long)span.getHighBoundedValue();
                    instant = Instant.ofEpochMilli(DateTimeEncoding.unpackMillisUtc((long)packedValue));
                    timeInfoBuilder.setPredicateUpperTimeBound(Optional.of(instant));
                }
            });
            return timeInfoBuilder.build();
        });
    }

    static String decimalSecondString(long millis) {
        return new BigDecimal(Long.toString(millis)).divide(new BigDecimal(1000L)).toPlainString();
    }

    private static class EffectiveLimits {
        private final Instant upperBound;
        private final java.time.Duration maxQueryRangeDuration;

        public EffectiveLimits(Instant defaultUpperBound, Duration maxQueryRangeDurationRequested, Optional<PrometheusPredicateTimeInfo> maybePredicateRange) {
            if (maybePredicateRange.isPresent()) {
                this.upperBound = maybePredicateRange.get().getPredicateUpperTimeBound().isPresent() ? maybePredicateRange.get().getPredicateUpperTimeBound().get() : defaultUpperBound;
                this.maxQueryRangeDuration = maybePredicateRange.get().getPredicateLowerTimeBound().isPresent() ? java.time.Duration.between(maybePredicateRange.get().getPredicateLowerTimeBound().get(), this.upperBound) : java.time.Duration.ofMillis(maxQueryRangeDurationRequested.toMillis());
            } else {
                this.upperBound = defaultUpperBound;
                this.maxQueryRangeDuration = java.time.Duration.ofMillis(maxQueryRangeDurationRequested.toMillis());
            }
        }

        public Instant getUpperBound() {
            return this.upperBound;
        }

        public java.time.Duration getMaxQueryRangeDuration() {
            return this.maxQueryRangeDuration;
        }
    }
}

