/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.prometheus.PrometheusClient;
import io.trino.plugin.prometheus.PrometheusColumnHandle;
import io.trino.plugin.prometheus.PrometheusRecordSet;
import io.trino.plugin.prometheus.PrometheusSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class PrometheusRecordSetProvider
implements ConnectorRecordSetProvider {
    private final PrometheusClient prometheusClient;

    @Inject
    public PrometheusRecordSetProvider(PrometheusClient prometheusClient) {
        this.prometheusClient = Objects.requireNonNull(prometheusClient, "prometheusClient is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        PrometheusSplit prometheusSplit = (PrometheusSplit)split;
        ImmutableList.Builder handles = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            handles.add((Object)((PrometheusColumnHandle)columnHandle));
        }
        return new PrometheusRecordSet(this.prometheusClient, prometheusSplit, (List<PrometheusColumnHandle>)handles.build());
    }
}

