/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.prometheus;

import com.google.common.collect.ImmutableList;
import com.google.inject.ConfigurationException;
import com.google.inject.spi.Message;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotNull;

public class PrometheusConnectorConfig {
    private URI prometheusURI = URI.create("http://localhost:9090");
    private Duration queryChunkSizeDuration = new Duration(1.0, TimeUnit.DAYS);
    private Duration maxQueryRangeDuration = new Duration(21.0, TimeUnit.DAYS);
    private Duration cacheDuration = new Duration(30.0, TimeUnit.SECONDS);
    private Duration readTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private File bearerTokenFile;
    private String user;
    private String password;

    @NotNull
    public URI getPrometheusURI() {
        return this.prometheusURI;
    }

    @Config(value="prometheus.uri")
    @ConfigDescription(value="Where to find Prometheus coordinator host")
    public PrometheusConnectorConfig setPrometheusURI(URI prometheusURI) {
        this.prometheusURI = prometheusURI;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getQueryChunkSizeDuration() {
        return this.queryChunkSizeDuration;
    }

    @Config(value="prometheus.query.chunk.size.duration")
    @ConfigDescription(value="The duration of each query to Prometheus")
    public PrometheusConnectorConfig setQueryChunkSizeDuration(Duration queryChunkSizeDuration) {
        this.queryChunkSizeDuration = queryChunkSizeDuration;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getMaxQueryRangeDuration() {
        return this.maxQueryRangeDuration;
    }

    @Config(value="prometheus.max.query.range.duration")
    @ConfigDescription(value="Width of overall query to Prometheus, will be divided into prometheus.query.chunk.size.duration queries")
    public PrometheusConnectorConfig setMaxQueryRangeDuration(Duration maxQueryRangeDuration) {
        this.maxQueryRangeDuration = maxQueryRangeDuration;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getCacheDuration() {
        return this.cacheDuration;
    }

    @Config(value="prometheus.cache.ttl")
    @ConfigDescription(value="How long values from this config file are cached")
    public PrometheusConnectorConfig setCacheDuration(Duration cacheConfigDuration) {
        this.cacheDuration = cacheConfigDuration;
        return this;
    }

    public Optional<File> getBearerTokenFile() {
        return Optional.ofNullable(this.bearerTokenFile);
    }

    @Config(value="prometheus.bearer.token.file")
    @ConfigDescription(value="File holding bearer token if needed for access to Prometheus")
    public PrometheusConnectorConfig setBearerTokenFile(File bearerTokenFile) {
        this.bearerTokenFile = bearerTokenFile;
        return this;
    }

    @NotNull
    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Config(value="prometheus.auth.user")
    public PrometheusConnectorConfig setUser(String user) {
        this.user = user;
        return this;
    }

    @NotNull
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Config(value="prometheus.auth.password")
    @ConfigSecuritySensitive
    public PrometheusConnectorConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Config(value="prometheus.read-timeout")
    @ConfigDescription(value="How much time a query to Prometheus has before timing out")
    public PrometheusConnectorConfig setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    @PostConstruct
    public void checkConfig() {
        long queryChunkSizeDuration;
        long maxQueryRangeDuration = (long)this.getMaxQueryRangeDuration().getValue(TimeUnit.SECONDS);
        if (maxQueryRangeDuration < (queryChunkSizeDuration = (long)this.getQueryChunkSizeDuration().getValue(TimeUnit.SECONDS))) {
            throw new ConfigurationException((Iterable)ImmutableList.of((Object)new Message("prometheus.max.query.range.duration must be greater than prometheus.query.chunk.size.duration")));
        }
        if (this.getBearerTokenFile().isPresent() && (this.getUser().isPresent() || this.getPassword().isPresent())) {
            throw new IllegalStateException("Either on of bearer token file or basic authentication should be used");
        }
        if (this.getUser().isPresent() ^ this.getPassword().isPresent()) {
            throw new IllegalStateException("Both username and password must be set when using basic authentication");
        }
    }
}

