/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql.rule;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.AbstractRewriteCast;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.Type;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public class RewriteCast
extends AbstractRewriteCast {
    private static final List<Integer> SUPPORTED_SOURCE_TYPE_FOR_INTEGRAL_CAST = ImmutableList.of((Object)-7, (Object)5, (Object)4, (Object)-5, (Object)2);

    public RewriteCast(BiFunction<ConnectorSession, Type, String> jdbcTypeProvider) {
        super(jdbcTypeProvider);
    }

    protected Optional<JdbcTypeHandle> toJdbcTypeHandle(JdbcTypeHandle sourceType, Type targetType) {
        if (!RewriteCast.pushdownSupported(sourceType, targetType)) {
            return Optional.empty();
        }
        Type type = targetType;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmallintType.class, IntegerType.class, BigintType.class}, (Type)type2, n)) {
            case 0 -> {
                SmallintType smallintType = (SmallintType)type2;
                yield Optional.of(new JdbcTypeHandle(5, Optional.of(smallintType.getBaseName()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
            }
            case 1 -> {
                IntegerType integerType = (IntegerType)type2;
                yield Optional.of(new JdbcTypeHandle(4, Optional.of(integerType.getBaseName()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
            }
            case 2 -> {
                BigintType bigintType = (BigintType)type2;
                yield Optional.of(new JdbcTypeHandle(-5, Optional.of(bigintType.getBaseName()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()));
            }
            default -> Optional.empty();
        };
    }

    private static boolean pushdownSupported(JdbcTypeHandle sourceType, Type targetType) {
        boolean bl;
        Type type = targetType;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        block3: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmallintType.class, IntegerType.class, BigintType.class}, (Type)type2, n)) {
                case 0: 
                case 1: 
                case 2: {
                    if (!(type2 instanceof SmallintType || type2 instanceof IntegerType || type2 instanceof BigintType)) {
                        n = 3;
                        continue block3;
                    }
                    bl = SUPPORTED_SOURCE_TYPE_FOR_INTEGRAL_CAST.contains(sourceType.jdbcType());
                    break block3;
                }
                default: {
                    bl = false;
                    break block3;
                }
            }
            break;
        }
        return bl;
    }

    protected String buildCast(Type sourceType, Type targetType, String expression, String castType) {
        if (sourceType instanceof DecimalType && RewriteCast.isIntegralType(targetType)) {
            return "CAST(ROUND(%s) AS %s)".formatted(expression, castType);
        }
        if (sourceType instanceof BooleanType && RewriteCast.isIntegralType(targetType)) {
            return "CAST(%s::INT AS %s)".formatted(expression, castType);
        }
        return "CAST(%s AS %s)".formatted(expression, castType);
    }

    private static boolean isIntegralType(Type type) {
        return type instanceof SmallintType || type instanceof IntegerType || type instanceof BigintType;
    }
}

