/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.LongMath;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.aggregation.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRewriter;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.plugin.base.mapping.IdentifierMapping;
import io.trino.plugin.base.projection.ProjectFunctionRewriter;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanReadFunction;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleReadFunction;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcJoinPushdownUtil;
import io.trino.plugin.jdbc.JdbcMetadataSessionProperties;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.PreparedQuery;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.ReadFunction;
import io.trino.plugin.jdbc.RemoteTableName;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.aggregation.ImplementAvgDecimal;
import io.trino.plugin.jdbc.aggregation.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.aggregation.ImplementCorr;
import io.trino.plugin.jdbc.aggregation.ImplementCount;
import io.trino.plugin.jdbc.aggregation.ImplementCountAll;
import io.trino.plugin.jdbc.aggregation.ImplementCountDistinct;
import io.trino.plugin.jdbc.aggregation.ImplementCovariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementCovarianceSamp;
import io.trino.plugin.jdbc.aggregation.ImplementMinMax;
import io.trino.plugin.jdbc.aggregation.ImplementRegrIntercept;
import io.trino.plugin.jdbc.aggregation.ImplementRegrSlope;
import io.trino.plugin.jdbc.aggregation.ImplementStddevPop;
import io.trino.plugin.jdbc.aggregation.ImplementStddevSamp;
import io.trino.plugin.jdbc.aggregation.ImplementSum;
import io.trino.plugin.jdbc.aggregation.ImplementVariancePop;
import io.trino.plugin.jdbc.aggregation.ImplementVarianceSamp;
import io.trino.plugin.jdbc.expression.JdbcConnectorExpressionRewriterBuilder;
import io.trino.plugin.jdbc.expression.ParameterizedExpression;
import io.trino.plugin.jdbc.expression.RewriteIn;
import io.trino.plugin.jdbc.logging.RemoteQueryModifier;
import io.trino.plugin.postgresql.ImplementAvgBigint;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlSessionProperties;
import io.trino.plugin.postgresql.TypeUtils;
import io.trino.plugin.postgresql.rule.RewriteDotProductFunction;
import io.trino.plugin.postgresql.rule.RewriteStringReverseFunction;
import io.trino.plugin.postgresql.rule.RewriteVectorDistanceFunction;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.SqlMap;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.predicate.Domain;
import io.trino.spi.statistics.ColumnStatistics;
import io.trino.spi.statistics.Estimate;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.PgConnection;

public class PostgreSqlClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(PostgreSqlClient.class);
    private static final int ARRAY_RESULT_SET_VALUE_COLUMN = 2;
    private static final String DUPLICATE_TABLE_SQLSTATE = "42P07";
    private static final int POSTGRESQL_MAX_SUPPORTED_TIMESTAMP_PRECISION = 6;
    private static final int PRECISION_OF_UNSPECIFIED_DECIMAL = 0;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
    private static final PredicatePushdownController POSTGRESQL_STRING_COLLATION_AWARE_PUSHDOWN = (session, domain) -> {
        if (domain.isOnlyNull()) {
            return PredicatePushdownController.FULL_PUSHDOWN.apply(session, domain);
        }
        if (PostgreSqlSessionProperties.isEnableStringPushdownWithCollate(session)) {
            return PredicatePushdownController.FULL_PUSHDOWN.apply(session, domain);
        }
        Domain simplifiedDomain = domain.simplify(JdbcMetadataSessionProperties.getDomainCompactionThreshold((ConnectorSession)session));
        if (!simplifiedDomain.getValues().isDiscreteSet()) {
            return PredicatePushdownController.DISABLE_PUSHDOWN.apply(session, domain);
        }
        return PredicatePushdownController.FULL_PUSHDOWN.apply(session, simplifiedDomain);
    };
    private final Type jsonType;
    private final Type uuidType;
    private final MapType varcharMapType;
    private final List<String> tableTypes;
    private final boolean statisticsEnabled;
    private final ConnectorExpressionRewriter<ParameterizedExpression> connectorExpressionRewriter;
    private final ProjectFunctionRewriter<JdbcExpression, ParameterizedExpression> projectFunctionRewriter;
    private final AggregateFunctionRewriter<JdbcExpression, ?> aggregateFunctionRewriter;
    private final Optional<Integer> fetchSize;

    @Inject
    public PostgreSqlClient(BaseJdbcConfig config, PostgreSqlConfig postgreSqlConfig, JdbcStatisticsConfig statisticsConfig, ConnectionFactory connectionFactory, QueryBuilder queryBuilder, TypeManager typeManager, IdentifierMapping identifierMapping, RemoteQueryModifier queryModifier) {
        super("\"", connectionFactory, queryBuilder, config.getJdbcTypesMappedToVarchar(), identifierMapping, queryModifier, true);
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.uuidType = typeManager.getType(new TypeSignature("uuid", new TypeSignatureParameter[0]));
        this.varcharMapType = (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        ImmutableList.Builder tableTypes = ImmutableList.builder();
        tableTypes.add((Object[])new String[]{"TABLE", "PARTITIONED TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE"});
        if (postgreSqlConfig.isIncludeSystemTables()) {
            tableTypes.add((Object[])new String[]{"SYSTEM TABLE", "SYSTEM VIEW"});
        }
        this.tableTypes = tableTypes.build();
        this.statisticsEnabled = statisticsConfig.isEnabled();
        Predicate<ConnectorSession> pushdownWithCollateEnabled = PostgreSqlSessionProperties::isEnableStringPushdownWithCollate;
        this.connectorExpressionRewriter = JdbcConnectorExpressionRewriterBuilder.newBuilder().addStandardRules(arg_0 -> ((PostgreSqlClient)this).quoted(arg_0)).add((ConnectorExpressionRule)new RewriteIn()).withTypeClass("integer_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint")).withTypeClass("numeric_type", (Set)ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"integer", (Object)"bigint", (Object)"decimal", (Object)"real", (Object[])new String[]{"double"})).map("$equal(left, right)").to("left = right").map("$not_equal(left, right)").to("left <> right").map("$identical(left, right)").to("left IS NOT DISTINCT FROM right").map("$less_than(left: numeric_type, right: numeric_type)").to("left < right").map("$less_than_or_equal(left: numeric_type, right: numeric_type)").to("left <= right").map("$greater_than(left: numeric_type, right: numeric_type)").to("left > right").map("$greater_than_or_equal(left: numeric_type, right: numeric_type)").to("left >= right").map("$add(left: integer_type, right: integer_type)").to("left + right").map("$subtract(left: integer_type, right: integer_type)").to("left - right").map("$multiply(left: integer_type, right: integer_type)").to("left * right").map("$divide(left: integer_type, right: integer_type)").to("left / right").map("$modulus(left: integer_type, right: integer_type)").to("left % right").map("$negate(value: integer_type)").to("-value").map("$like(value: varchar, pattern: varchar): boolean").to("value LIKE pattern").map("$like(value: varchar, pattern: varchar, escape: varchar(1)): boolean").to("value LIKE pattern ESCAPE escape").map("$not($is_null(value))").to("value IS NOT NULL").map("$not(value: boolean)").to("NOT value").map("$is_null(value)").to("value IS NULL").map("$nullif(first, second)").to("NULLIF(first, second)").withTypeClass("collatable_type", (Set)ImmutableSet.of((Object)"char", (Object)"varchar")).when(pushdownWithCollateEnabled).map("$less_than(left: collatable_type, right: collatable_type)").to("left < right COLLATE \"C\"").when(pushdownWithCollateEnabled).map("$less_than_or_equal(left: collatable_type, right: collatable_type)").to("left <= right COLLATE \"C\"").when(pushdownWithCollateEnabled).map("$greater_than(left: collatable_type, right: collatable_type)").to("left > right COLLATE \"C\"").when(pushdownWithCollateEnabled).map("$greater_than_or_equal(left: collatable_type, right: collatable_type)").to("left >= right COLLATE \"C\"").build();
        this.projectFunctionRewriter = new ProjectFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new RewriteStringReverseFunction()).add((Object)new RewriteVectorDistanceFunction("euclidean_distance", "<->")).add((Object)new RewriteVectorDistanceFunction("cosine_distance", "<=>")).add((Object)new RewriteDotProductFunction()).build());
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(this.connectorExpressionRewriter, (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementMinMax(false)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementCountDistinct(bigintTypeHandle, false)).add((Object)new ImplementSum(PostgreSqlClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).add((Object)new ImplementCovarianceSamp()).add((Object)new ImplementCovariancePop()).add((Object)new ImplementCorr()).add((Object)new ImplementRegrIntercept()).add((Object)new ImplementRegrSlope()).build());
        this.fetchSize = postgreSqlConfig.getFetchSize();
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = DUPLICATE_TABLE_SQLSTATE.equals(e.getSQLState());
            throw new TrinoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    protected List<String> createTableSqls(RemoteTableName remoteTableName, List<String> columns, ConnectorTableMetadata tableMetadata) {
        Preconditions.checkArgument((boolean)tableMetadata.getProperties().isEmpty(), (String)"Unsupported table properties: %s", (Object)tableMetadata.getProperties());
        ImmutableList.Builder createTableSqlsBuilder = ImmutableList.builder();
        createTableSqlsBuilder.add((Object)String.format("CREATE TABLE %s (%s)", this.quoted(remoteTableName), String.join((CharSequence)", ", columns)));
        Optional tableComment = tableMetadata.getComment();
        if (tableComment.isPresent()) {
            createTableSqlsBuilder.add((Object)this.buildTableCommentSql(remoteTableName, tableComment));
        }
        return createTableSqlsBuilder.build();
    }

    public void setTableComment(ConnectorSession session, JdbcTableHandle handle, Optional<String> comment) {
        this.execute(session, this.buildTableCommentSql(handle.asPlainTable().getRemoteTableName(), comment));
    }

    private String buildTableCommentSql(RemoteTableName remoteTableName, Optional<String> comment) {
        return String.format("COMMENT ON TABLE %s IS %s", this.quoted(remoteTableName), comment.map(BaseJdbcClient::varcharLiteral).orElse("NULL"));
    }

    protected void renameTable(ConnectorSession session, Connection connection, String catalogName, String remoteSchemaName, String remoteTableName, String newRemoteSchemaName, String newRemoteTableName) throws SQLException {
        if (!remoteSchemaName.equals(newRemoteSchemaName)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        this.execute(session, connection, String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, remoteSchemaName, remoteTableName), this.quoted(newRemoteTableName)));
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql, Optional<Integer> columnCount) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        Optional<Integer> fetchSize = Optional.ofNullable(this.fetchSize.orElseGet(() -> columnCount.map(count -> Math.max(100000 / count, 1000)).orElse(null)));
        if (fetchSize.isPresent()) {
            statement.setFetchSize(fetchSize.get());
        }
        return statement;
    }

    protected Optional<List<String>> getTableTypes() {
        return Optional.of(this.tableTypes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return (List)tableHandle.getColumns().get();
        }
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        SchemaTableName schemaTableName = tableHandle.getRequiredNamedRelation().getSchemaTableName();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block19: {
                Object arrayColumnDimensions = ImmutableMap.of();
                if (PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
                    arrayColumnDimensions = PostgreSqlClient.getArrayColumnDimensions(connection, tableHandle);
                }
                ResultSet resultSet = this.getColumns(tableHandle, connection.getMetaData());
                try {
                    int allColumns = 0;
                    ArrayList<JdbcColumnHandle> columns = new ArrayList<JdbcColumnHandle>();
                    while (resultSet.next()) {
                        ++allColumns;
                        String columnName = resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle(((Integer)PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null"))).intValue(), Optional.of(resultSet.getString("TYPE_NAME")), PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"COLUMN_SIZE"), PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"DECIMAL_DIGITS"), Optional.ofNullable((Integer)arrayColumnDimensions.get(columnName)), Optional.empty());
                        Optional<ColumnMapping> columnMapping = this.toColumnMapping(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{schemaTableName, columnName, typeHandle, columnMapping});
                        if (columnMapping.isPresent()) {
                            boolean nullable = resultSet.getInt("NULLABLE") != 0;
                            Optional<String> comment = Optional.ofNullable(resultSet.getString("REMARKS"));
                            columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(columnMapping.get().getType()).setNullable(nullable).setComment(comment).build());
                        }
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toColumnMapping() returned empty for %s", (Object)unsupportedTypeHandling, (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(schemaTableName, String.format("Table '%s' has no supported columns (all %s columns are not supported)", schemaTableName, allColumns));
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block19;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    protected ResultSet getAllTableColumns(Connection connection, Optional<String> remoteSchemaName) throws SQLException {
        return super.getAllTableColumns(connection, remoteSchemaName);
    }

    private static Map<String, Integer> getArrayColumnDimensions(Connection connection, JdbcTableHandle tableHandle) throws SQLException {
        String sql = "SELECT att.attname, greatest(att.attndims, 1) AS attndims FROM pg_attribute att   JOIN pg_type attyp ON att.atttypid = attyp.oid  JOIN pg_class tbl ON tbl.oid = att.attrelid   JOIN pg_namespace ns ON tbl.relnamespace = ns.oid WHERE ns.nspname = ? AND tbl.relname = ? AND attyp.typcategory = 'A' ";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            RemoteTableName remoteTableName = tableHandle.getRequiredNamedRelation().getRemoteTableName();
            statement.setString(1, remoteTableName.getSchemaName().orElse(null));
            statement.setString(2, remoteTableName.getTableName());
            HashMap<String, Integer> arrayColumnDimensions = new HashMap<String, Integer>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    arrayColumnDimensions.put(resultSet.getString("attname"), resultSet.getInt("attndims"));
                }
            }
            HashMap<String, Integer> hashMap = arrayColumnDimensions;
            return hashMap;
        }
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(typeHandle)));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName) {
            case "money": {
                return Optional.of(PostgreSqlClient.moneyColumnMapping());
            }
            case "uuid": {
                return Optional.of(this.uuidColumnMapping());
            }
            case "jsonb": 
            case "json": {
                return Optional.of(this.jsonColumnMapping());
            }
            case "timestamptz": {
                int decimalDigits = typeHandle.requiredDecimalDigits();
                return Optional.of(PostgreSqlClient.timestampWithTimeZoneColumnMapping(decimalDigits));
            }
            case "hstore": {
                return Optional.of(this.hstoreColumnMapping(session));
            }
            case "vector": {
                return Optional.of(PostgreSqlClient.vectorColumnMapping());
            }
        }
        if (jdbcTypeName.endsWith("\"vector\"")) {
            return Optional.of(PostgreSqlClient.vectorColumnMapping());
        }
        switch (typeHandle.jdbcType()) {
            case -7: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: {
                int precision;
                int columnSize = typeHandle.requiredColumnSize();
                int decimalDigits = typeHandle.decimalDigits().orElse(0);
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW) {
                    if (columnSize == 0) {
                        return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session)), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                    }
                    precision = columnSize;
                    if (precision > 38) {
                        int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                        return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                    }
                }
                precision = columnSize + Math.max(-decimalDigits, 0);
                if (columnSize == 0 || precision > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case 1: {
                return Optional.of(PostgreSqlClient.charColumnMapping(typeHandle.requiredColumnSize()));
            }
            case 12: {
                if (!jdbcTypeName.equals("varchar")) {
                    return Optional.of(PostgreSqlClient.typedVarcharColumnMapping(jdbcTypeName));
                }
                return Optional.of(PostgreSqlClient.varcharColumnMapping(typeHandle.requiredColumnSize()));
            }
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMappingUsingLocalDate());
            }
            case 92: {
                return Optional.of(PostgreSqlClient.timeColumnMapping(typeHandle.requiredDecimalDigits()));
            }
            case 93: {
                TimestampType timestampType = TimestampType.createTimestampType((int)typeHandle.requiredDecimalDigits());
                return Optional.of(ColumnMapping.longMapping((Type)timestampType, (LongReadFunction)StandardColumnMappings.timestampReadFunction((TimestampType)timestampType), PostgreSqlClient::shortTimestampWriteFunction));
            }
            case 2003: {
                Optional<ColumnMapping> columnMapping = this.arrayToTrinoType(session, connection, typeHandle);
                if (!columnMapping.isPresent()) break;
                return columnMapping;
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return PostgreSqlClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private Optional<ColumnMapping> arrayToTrinoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Preconditions.checkArgument((typeHandle.jdbcType() == 2003 ? 1 : 0) != 0, (Object)"Not array type");
        PostgreSqlConfig.ArrayMapping arrayMapping = PostgreSqlSessionProperties.getArrayMapping(session);
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.DISABLED) {
            return Optional.empty();
        }
        JdbcTypeHandle baseElementTypeHandle = PostgreSqlClient.getArrayElementTypeHandle(connection, typeHandle);
        String baseElementTypeName = (String)baseElementTypeHandle.jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Element type name is missing: " + String.valueOf(baseElementTypeHandle)));
        if (baseElementTypeHandle.jdbcType() == -2) {
            return Optional.empty();
        }
        Optional<ColumnMapping> baseElementMapping = this.toColumnMapping(session, connection, baseElementTypeHandle);
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
            if (typeHandle.arrayDimensions().isEmpty()) {
                return Optional.empty();
            }
            return baseElementMapping.map(elementMapping -> {
                ArrayType trinoArrayType = new ArrayType(elementMapping.getType());
                ColumnMapping arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, trinoArrayType, elementMapping, baseElementTypeName);
                int arrayDimensions = (Integer)typeHandle.arrayDimensions().get();
                for (int i = 1; i < arrayDimensions; ++i) {
                    trinoArrayType = new ArrayType((Type)trinoArrayType);
                    arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, trinoArrayType, arrayColumnMapping, baseElementTypeName);
                }
                return arrayColumnMapping;
            });
        }
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_JSON) {
            return baseElementMapping.map(elementMapping -> this.arrayAsJsonColumnMapping(session, (ColumnMapping)elementMapping));
        }
        throw new IllegalStateException("Unsupported array mapping type: " + String.valueOf((Object)arrayMapping));
    }

    public Optional<Type> getSupportedType(ConnectorSession session, Type type) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        TimestampType timestampType;
        TimeType timeType;
        if (type instanceof TimeType && (timeType = (TimeType)type).getPrecision() > 6) {
            return Optional.of(TimeType.createTimeType((int)6));
        }
        if (type instanceof TimestampType && (timestampType = (TimestampType)type).getPrecision() > 6) {
            return Optional.of(TimestampType.createTimestampType((int)6));
        }
        if (type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).getPrecision() > 6) {
            return Optional.of(TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)6));
        }
        return Optional.empty();
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping((String)("char(" + ((CharType)type).getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"bytea", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunctionUsingLocalDate());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            Verify.verify((timeType.getPrecision() <= 6 ? 1 : 0) != 0);
            return WriteMapping.longMapping((String)String.format("time(%s)", timeType.getPrecision()), (LongWriteFunction)PostgreSqlClient.timeWriteFunction(timeType.getPrecision()));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            Verify.verify((timestampType.getPrecision() <= 6 ? 1 : 0) != 0);
            return WriteMapping.longMapping((String)String.format("timestamp(%s)", timestampType.getPrecision()), PostgreSqlClient::shortTimestampWriteFunction);
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            Verify.verify((timestampWithTimeZoneType.getPrecision() <= 6 ? 1 : 0) != 0);
            String dataType = String.format("timestamptz(%d)", timestampWithTimeZoneType.getPrecision());
            if (timestampWithTimeZoneType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)PostgreSqlClient.shortTimestampWithTimeZoneWriteFunction());
            }
            return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
        }
        if (type.equals((Object)this.jsonType)) {
            return WriteMapping.sliceMapping((String)"jsonb", (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"));
        }
        if (type.equals((Object)this.uuidType)) {
            return WriteMapping.sliceMapping((String)"uuid", (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
                Type elementType = arrayType.getElementType();
                String elementDataType = this.toWriteMapping(session, elementType).getDataType();
                return WriteMapping.objectMapping((String)(elementDataType + "[]"), (ObjectWriteFunction)PostgreSqlClient.arrayWriteFunction(session, elementType, TypeUtils.getArrayElementPgTypeName(session, this, elementType)));
            }
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    public boolean supportsAggregationPushdown(ConnectorSession session, JdbcTableHandle table, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        return PostgreSqlClient.preventTextualTypeAggregationPushdown(groupingSets);
    }

    public Optional<ParameterizedExpression> convertPredicate(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.connectorExpressionRewriter.rewrite(session, expression, assignments);
    }

    public Optional<JdbcExpression> convertProjection(ConnectorSession session, ConnectorExpression expression, Map<String, ColumnHandle> assignments) {
        return this.projectFunctionRewriter.rewrite(session, expression, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.column().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType) || PostgreSqlClient.isCollatable(sortItem.column())) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().map(sortItem -> {
                String ordering = sortItem.sortOrder().isAscending() ? "ASC" : "DESC";
                String nullsHandling = sortItem.sortOrder().isNullsFirst() ? "NULLS FIRST" : "NULLS LAST";
                String collation = "";
                if (PostgreSqlClient.isCollatable(sortItem.column())) {
                    collation = "COLLATE \"C\"";
                }
                return String.format("%s %s %s %s", this.quoted(sortItem.column().getColumnName()), collation, ordering, nullsHandling);
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %d", query, orderBy, limit);
        });
    }

    protected static boolean isCollatable(JdbcColumnHandle column) {
        if (column.getColumnType() instanceof CharType || column.getColumnType() instanceof VarcharType) {
            String jdbcTypeName = (String)column.getJdbcTypeHandle().jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(column.getJdbcTypeHandle())));
            return PostgreSqlClient.isCollatable(jdbcTypeName);
        }
        return false;
    }

    private static boolean isCollatable(String jdbcTypeName) {
        return "bpchar".equals(jdbcTypeName) || "varchar".equals(jdbcTypeName) || "text".equals(jdbcTypeName);
    }

    public boolean isTopNGuaranteed(ConnectorSession session) {
        return true;
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OptionalLong delete(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to delete from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to delete when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to delete when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getUpdateAssignments().isEmpty(), (String)"Unable to delete when update assignments are set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareDeleteQuery((JdbcClient)this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), PostgreSqlClient.getAdditionalPredicate((List)handle.getConstraintExpressions(), Optional.empty()));
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.empty());
                try {
                    int affectedRowsCount = preparedStatement.executeUpdate();
                    connection.commit();
                    optionalLong = OptionalLong.of(affectedRowsCount);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OptionalLong update(ConnectorSession session, JdbcTableHandle handle) {
        Preconditions.checkArgument((boolean)handle.isNamedRelation(), (String)"Unable to update from synthetic table: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getLimit().isEmpty(), (String)"Unable to update when limit is set: %s", (Object)handle);
        Preconditions.checkArgument((boolean)handle.getSortOrder().isEmpty(), (String)"Unable to update when sort order is set: %s", (Object)handle);
        Preconditions.checkArgument((!handle.getUpdateAssignments().isEmpty() ? 1 : 0) != 0, (String)"Unable to update when update assignments are not set: %s", (Object)handle);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            OptionalLong optionalLong;
            block14: {
                Verify.verify((boolean)connection.getAutoCommit());
                PreparedQuery preparedQuery = this.queryBuilder.prepareUpdateQuery((JdbcClient)this, session, connection, handle.getRequiredNamedRelation(), handle.getConstraint(), PostgreSqlClient.getAdditionalPredicate((List)handle.getConstraintExpressions(), Optional.empty()), handle.getUpdateAssignments());
                PreparedStatement preparedStatement = this.queryBuilder.prepareStatement((JdbcClient)this, session, connection, preparedQuery, Optional.empty());
                try {
                    int affectedRows = preparedStatement.executeUpdate();
                    connection.commit();
                    optionalLong = OptionalLong.of(affectedRows);
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return optionalLong;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    public OptionalInt getMaxColumnNameLength(ConnectorSession session) {
        return this.getMaxColumnNameLengthFromDatabaseMetaData(session);
    }

    public TableStatistics getTableStatistics(ConnectorSession session, JdbcTableHandle handle) {
        if (!this.statisticsEnabled) {
            return TableStatistics.empty();
        }
        if (!handle.isNamedRelation()) {
            return TableStatistics.empty();
        }
        try {
            return this.readTableStatistics(session, handle);
        }
        catch (RuntimeException | SQLException e) {
            Throwables.throwIfInstanceOf((Throwable)e, TrinoException.class);
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Failed fetching statistics for table: " + String.valueOf(handle), (Throwable)e);
        }
    }

    private TableStatistics readTableStatistics(ConnectorSession session, JdbcTableHandle table) throws SQLException {
        Preconditions.checkArgument((boolean)table.isNamedRelation(), (String)"Relation is not a table: %s", (Object)table);
        try (Connection connection = this.connectionFactory.openConnection(session);){
            TableStatistics tableStatistics;
            block25: {
                TableStatistics.Builder tableStatistics2;
                long rowCount;
                StatisticsDao statisticsDao;
                Handle handle;
                block23: {
                    TableStatistics tableStatistics3;
                    block24: {
                        block21: {
                            TableStatistics tableStatistics4;
                            block22: {
                                Optional<Long> optionalRowCount;
                                block19: {
                                    TableStatistics tableStatistics5;
                                    block20: {
                                        handle = Jdbi.open((Connection)connection);
                                        statisticsDao = new StatisticsDao(handle);
                                        optionalRowCount = PostgreSqlClient.readRowCountTableStat(statisticsDao, table);
                                        if (!optionalRowCount.isEmpty()) break block19;
                                        tableStatistics5 = TableStatistics.empty();
                                        if (handle == null) break block20;
                                        handle.close();
                                    }
                                    return tableStatistics5;
                                }
                                rowCount = optionalRowCount.get();
                                if (rowCount != -1L) break block21;
                                tableStatistics4 = TableStatistics.empty();
                                if (handle == null) break block22;
                                handle.close();
                            }
                            return tableStatistics4;
                        }
                        tableStatistics2 = TableStatistics.builder();
                        tableStatistics2.setRowCount(Estimate.of((double)rowCount));
                        if (rowCount != 0L) break block23;
                        tableStatistics3 = tableStatistics2.build();
                        if (handle == null) break block24;
                        handle.close();
                    }
                    return tableStatistics3;
                }
                try {
                    RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
                    Map columnStatistics = (Map)statisticsDao.getColumnStatistics(remoteTableName.getSchemaName().orElse(null), remoteTableName.getTableName()).stream().collect(ImmutableMap.toImmutableMap(ColumnStatisticsResult::getColumnName, Function.identity()));
                    for (JdbcColumnHandle column : this.getColumns(session, table)) {
                        ColumnStatisticsResult result = (ColumnStatisticsResult)columnStatistics.get(column.getColumnName());
                        if (result == null) continue;
                        ColumnStatistics statistics = ColumnStatistics.builder().setNullsFraction(result.getNullsFraction().map(Estimate::of).orElseGet(Estimate::unknown)).setDistinctValuesCount(result.getDistinctValuesIndicator().map(distinctValuesIndicator -> {
                            if ((double)distinctValuesIndicator.floatValue() >= 0.0) {
                                return distinctValuesIndicator;
                            }
                            return Float.valueOf(-distinctValuesIndicator.floatValue() * (float)rowCount);
                        }).map(Estimate::of).orElseGet(Estimate::unknown)).setDataSize(result.getAverageColumnLength().flatMap(averageColumnLength -> result.getNullsFraction().map(nullsFraction -> Estimate.of((double)(1.0 * (double)averageColumnLength.intValue() * (double)rowCount * (double)(1.0f - nullsFraction.floatValue()))))).orElseGet(Estimate::unknown)).build();
                        tableStatistics2.setColumnStatistics((ColumnHandle)column, statistics);
                    }
                    tableStatistics = tableStatistics2.build();
                    if (handle == null) break block25;
                }
                catch (Throwable throwable) {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                handle.close();
            }
            return tableStatistics;
        }
    }

    private static Optional<Long> readRowCountTableStat(StatisticsDao statisticsDao, JdbcTableHandle table) {
        RemoteTableName remoteTableName = table.getRequiredNamedRelation().getRemoteTableName();
        String schemaName = remoteTableName.getSchemaName().orElse(null);
        Optional<Long> rowCount = statisticsDao.getRowCountFromPgClass(schemaName, remoteTableName.getTableName());
        if (rowCount.isEmpty()) {
            return Optional.empty();
        }
        if (statisticsDao.isPartitionedTable(schemaName, remoteTableName.getTableName())) {
            Optional<Long> partitionedTableRowCount = statisticsDao.getRowCountPartitionedTableFromPgClass(schemaName, remoteTableName.getTableName());
            if (partitionedTableRowCount.isPresent()) {
                return partitionedTableRowCount;
            }
            return statisticsDao.getRowCountPartitionedTableFromPgStats(schemaName, remoteTableName.getTableName());
        }
        if (rowCount.get() == 0L) {
            rowCount = statisticsDao.getRowCountFromPgStat(schemaName, remoteTableName.getTableName());
        }
        return rowCount;
    }

    public Optional<PreparedQuery> implementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, Map<JdbcColumnHandle, String> leftProjections, PreparedQuery rightSource, Map<JdbcColumnHandle, String> rightProjections, List<ParameterizedExpression> joinConditions, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return JdbcJoinPushdownUtil.implementJoinCostAware((ConnectorSession)session, (JoinType)joinType, (PreparedQuery)leftSource, (PreparedQuery)rightSource, (JoinStatistics)statistics, () -> super.implementJoin(session, joinType, leftSource, leftProjections, rightSource, rightProjections, joinConditions, statistics));
    }

    public Optional<PreparedQuery> legacyImplementJoin(ConnectorSession session, JoinType joinType, PreparedQuery leftSource, PreparedQuery rightSource, List<JdbcJoinCondition> joinConditions, Map<JdbcColumnHandle, String> rightAssignments, Map<JdbcColumnHandle, String> leftAssignments, JoinStatistics statistics) {
        if (joinType == JoinType.FULL_OUTER) {
            return Optional.empty();
        }
        return JdbcJoinPushdownUtil.implementJoinCostAware((ConnectorSession)session, (JoinType)joinType, (PreparedQuery)leftSource, (PreparedQuery)rightSource, (JoinStatistics)statistics, () -> super.legacyImplementJoin(session, joinType, leftSource, rightSource, joinConditions, rightAssignments, leftAssignments, statistics));
    }

    protected boolean isSupportedJoinCondition(ConnectorSession session, JdbcJoinCondition joinCondition) {
        boolean isVarchar = Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).anyMatch(type -> type instanceof CharType || type instanceof VarcharType);
        if (isVarchar) {
            JoinCondition.Operator operator = joinCondition.getOperator();
            return switch (operator) {
                default -> throw new MatchException(null, null);
                case JoinCondition.Operator.LESS_THAN, JoinCondition.Operator.LESS_THAN_OR_EQUAL, JoinCondition.Operator.GREATER_THAN, JoinCondition.Operator.GREATER_THAN_OR_EQUAL -> PostgreSqlSessionProperties.isEnableStringPushdownWithCollate(session);
                case JoinCondition.Operator.EQUAL, JoinCondition.Operator.NOT_EQUAL, JoinCondition.Operator.IDENTICAL -> true;
            };
        }
        return true;
    }

    protected void verifySchemaName(DatabaseMetaData databaseMetadata, String schemaName) throws SQLException {
        if (schemaName.length() > databaseMetadata.getMaxSchemaNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Schema name must be shorter than or equal to '%s' characters but got '%s'", databaseMetadata.getMaxSchemaNameLength(), schemaName.length()));
        }
    }

    protected void verifyTableName(DatabaseMetaData databaseMetadata, String tableName) throws SQLException {
        if (tableName.length() > databaseMetadata.getMaxTableNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Table name must be shorter than or equal to '%s' characters but got '%s'", databaseMetadata.getMaxTableNameLength(), tableName.length()));
        }
    }

    protected void verifyColumnName(DatabaseMetaData databaseMetadata, String columnName) throws SQLException {
        if (columnName.length() > databaseMetadata.getMaxColumnNameLength()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Column name must be shorter than or equal to '%s' characters but got '%s': '%s'", databaseMetadata.getMaxColumnNameLength(), columnName.length(), columnName));
        }
    }

    private static ColumnMapping charColumnMapping(int charLength) {
        if (charLength > 65536) {
            return PostgreSqlClient.varcharColumnMapping(charLength);
        }
        CharType charType = CharType.createCharType((int)charLength);
        return ColumnMapping.sliceMapping((Type)charType, (SliceReadFunction)StandardColumnMappings.charReadFunction((CharType)charType), (SliceWriteFunction)StandardColumnMappings.charWriteFunction(), (PredicatePushdownController)POSTGRESQL_STRING_COLLATION_AWARE_PUSHDOWN);
    }

    private static ColumnMapping varcharColumnMapping(int varcharLength) {
        VarcharType varcharType = varcharLength <= 0x7FFFFFFE ? VarcharType.createVarcharType((int)varcharLength) : VarcharType.createUnboundedVarcharType();
        return ColumnMapping.sliceMapping((Type)varcharType, (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)varcharType), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)POSTGRESQL_STRING_COLLATION_AWARE_PUSHDOWN);
    }

    private static ColumnMapping timeColumnMapping(int precision) {
        Verify.verify((precision <= 6 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        return ColumnMapping.longMapping((Type)TimeType.createTimeType((int)precision), (resultSet, columnIndex) -> {
            LocalTime time = resultSet.getObject(columnIndex, LocalTime.class);
            long nanosOfDay = time.toNanoOfDay();
            if (nanosOfDay == 86399999999999L) {
                nanosOfDay = 86400000000000L - LongMath.pow((long)10L, (int)(9 - precision));
            }
            long picosOfDay = nanosOfDay * 1000L;
            return Timestamps.round((long)picosOfDay, (int)(12 - precision));
        }, (LongWriteFunction)PostgreSqlClient.timeWriteFunction(precision), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static LongWriteFunction timeWriteFunction(final int precision) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        final String bindExpression = String.format("CAST(? AS time(%s))", precision);
        return new LongWriteFunction(){

            public String getBindExpression() {
                return bindExpression;
            }

            public void set(PreparedStatement statement, int index, long picosOfDay) throws SQLException {
                if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                    picosOfDay = 0L;
                }
                LocalTime localTime = LocalTime.ofNanoOfDay(picosOfDay / 1000L);
                statement.setString(index, TIME_FORMATTER.format(localTime));
            }
        };
    }

    private static void shortTimestampWriteFunction(PreparedStatement statement, int index, long epochMicros) throws SQLException {
        LocalDateTime localDateTime = StandardColumnMappings.fromTrinoTimestamp((long)epochMicros);
        statement.setObject(index, TypeUtils.toPgTimestamp(localDateTime));
    }

    private static ObjectWriteFunction longTimestampWriteFunction() {
        return ObjectWriteFunction.of(LongTimestamp.class, (statement, index, timestamp) -> {
            Verify.verify((boolean)true);
            long epochMicros = timestamp.getEpochMicros();
            if (timestamp.getPicosOfMicro() >= 500000) {
                ++epochMicros;
            }
            PostgreSqlClient.shortTimestampWriteFunction(statement, index, epochMicros);
        });
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("COMMENT ON COLUMN %s.%s IS %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(column.getColumnName()), comment.map(BaseJdbcClient::varcharLiteral).orElse("NULL"));
        this.execute(session, sql);
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping(int precision) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (String)"unsupported precision value %s", (int)precision);
        TimestampWithTimeZoneType trinoType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision);
        if (precision <= 3) {
            return ColumnMapping.longMapping((Type)trinoType, (LongReadFunction)PostgreSqlClient.shortTimestampWithTimeZoneReadFunction(), (LongWriteFunction)PostgreSqlClient.shortTimestampWithTimeZoneWriteFunction());
        }
        return ColumnMapping.objectMapping((Type)trinoType, (ObjectReadFunction)PostgreSqlClient.longTimestampWithTimeZoneReadFunction(), (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
    }

    private static LongReadFunction shortTimestampWithTimeZoneReadFunction() {
        return (resultSet, columnIndex) -> {
            long millisUtc = resultSet.getTimestamp(columnIndex).getTime();
            return DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        };
    }

    private static LongWriteFunction shortTimestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            statement.setTimestamp(index, new Timestamp(millisUtc));
        };
    }

    private static ObjectReadFunction longTimestampWithTimeZoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)offsetDateTime.toEpochSecond(), (long)((long)offsetDateTime.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
        });
    }

    private static ObjectWriteFunction longTimestampWithTimeZoneWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochSeconds = Math.floorDiv(value.getEpochMillis(), 1000);
            long nanosOfSecond = Math.floorMod(value.getEpochMillis(), 1000) * 1000000 + value.getPicosOfMilli() / 1000;
            statement.setObject(index, OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId()));
        });
    }

    private ColumnMapping hstoreColumnMapping(ConnectorSession session) {
        return ColumnMapping.objectMapping((Type)this.varcharMapType, (ObjectReadFunction)this.varcharMapReadFunction(), (ObjectWriteFunction)this.hstoreWriteFunction(session), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private ObjectReadFunction varcharMapReadFunction() {
        return ObjectReadFunction.of(SqlMap.class, (resultSet, columnIndex) -> {
            Map map = (Map)resultSet.getObject(columnIndex);
            BlockBuilder keyBlockBuilder = this.varcharMapType.getKeyType().createBlockBuilder(null, map.size());
            BlockBuilder valueBlockBuilder = this.varcharMapType.getValueType().createBlockBuilder(null, map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "hstore key is null");
                }
                this.varcharMapType.getKeyType().writeSlice(keyBlockBuilder, Slices.utf8Slice((String)((String)entry.getKey())));
                if (entry.getValue() == null) {
                    valueBlockBuilder.appendNull();
                    continue;
                }
                this.varcharMapType.getValueType().writeSlice(valueBlockBuilder, Slices.utf8Slice((String)((String)entry.getValue())));
            }
            MapBlock mapBlock = this.varcharMapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, map.size()}, keyBlockBuilder.build(), valueBlockBuilder.build());
            return this.varcharMapType.getObject((Block)mapBlock, 0);
        });
    }

    private ObjectWriteFunction hstoreWriteFunction(ConnectorSession session) {
        return ObjectWriteFunction.of(SqlMap.class, (statement, index, sqlMap) -> {
            int rawOffset = sqlMap.getRawOffset();
            Block rawKeyBlock = sqlMap.getRawKeyBlock();
            Block rawValueBlock = sqlMap.getRawValueBlock();
            Type keyType = this.varcharMapType.getKeyType();
            Type valueType = this.varcharMapType.getValueType();
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < sqlMap.getSize(); ++i) {
                map.put(keyType.getObjectValue(session, rawKeyBlock, rawOffset + i), valueType.getObjectValue(session, rawValueBlock, rawOffset + i));
            }
            statement.setObject(index, Collections.unmodifiableMap(map));
        });
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, ColumnMapping arrayElementMapping, String baseElementJdbcTypeName) {
        return ColumnMapping.objectMapping((Type)arrayType, (ObjectReadFunction)PostgreSqlClient.arrayReadFunction(arrayType.getElementType(), arrayElementMapping.getReadFunction()), (ObjectWriteFunction)PostgreSqlClient.arrayWriteFunction(session, arrayType.getElementType(), baseElementJdbcTypeName));
    }

    private static ObjectReadFunction arrayReadFunction(Type elementType, ReadFunction elementReadFunction) {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Array array = resultSet.getArray(columnIndex);
            BlockBuilder builder = elementType.createBlockBuilder(null, 10);
            try (ResultSet arrayAsResultSet = array.getResultSet();){
                while (arrayAsResultSet.next()) {
                    if (elementReadFunction.isNull(arrayAsResultSet, 2)) {
                        builder.appendNull();
                        continue;
                    }
                    if (elementType.getJavaType() == Boolean.TYPE) {
                        elementType.writeBoolean(builder, ((BooleanReadFunction)elementReadFunction).readBoolean(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Long.TYPE) {
                        elementType.writeLong(builder, ((LongReadFunction)elementReadFunction).readLong(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Double.TYPE) {
                        elementType.writeDouble(builder, ((DoubleReadFunction)elementReadFunction).readDouble(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Slice.class) {
                        elementType.writeSlice(builder, ((SliceReadFunction)elementReadFunction).readSlice(arrayAsResultSet, 2));
                        continue;
                    }
                    elementType.writeObject(builder, ((ObjectReadFunction)elementReadFunction).readObject(arrayAsResultSet, 2));
                }
            }
            return builder.build();
        });
    }

    private static ObjectWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String baseElementJdbcTypeName) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(baseElementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        });
    }

    private ColumnMapping arrayAsJsonColumnMapping(ConnectorSession session, ColumnMapping baseElementMapping) {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (SliceReadFunction)PostgreSqlClient.arrayAsJsonReadFunction(session, baseElementMapping), (statement, index, block) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to array type is unsupported");
        }, (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static SliceReadFunction arrayAsJsonReadFunction(ConnectorSession session, ColumnMapping baseElementMapping) {
        return (resultSet, columnIndex) -> {
            Object jdbcArray = resultSet.getArray(columnIndex).getArray();
            int arrayDimensions = TypeUtils.arrayDepth(jdbcArray);
            ReadFunction readFunction = baseElementMapping.getReadFunction();
            Type type = baseElementMapping.getType();
            for (int i = 0; i < arrayDimensions; ++i) {
                readFunction = PostgreSqlClient.arrayReadFunction(type, readFunction);
                type = new ArrayType(type);
            }
            Block block = (Block)((ObjectReadFunction)readFunction).readObject(resultSet, columnIndex);
            BlockBuilder builder = type.createBlockBuilder(null, 1);
            type.writeObject(builder, (Object)block);
            Object value = type.getObjectValue(session, builder.build(), 0);
            try {
                return JsonTypeUtil.toJsonValue((Object)value);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Conversion to JSON failed for  " + type.getDisplayName(), (Throwable)e);
            }
        };
    }

    private static JdbcTypeHandle getArrayElementTypeHandle(Connection connection, JdbcTypeHandle arrayTypeHandle) {
        String jdbcTypeName = (String)arrayTypeHandle.jdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + String.valueOf(arrayTypeHandle)));
        try {
            TypeInfo typeInfo = connection.unwrap(PgConnection.class).getTypeInfo();
            int pgElementOid = typeInfo.getPGArrayElement(typeInfo.getPGType(jdbcTypeName));
            Verify.verify((boolean)arrayTypeHandle.caseSensitivity().isEmpty(), (String)"Case sensitivity not supported", (Object[])new Object[0]);
            return new JdbcTypeHandle(typeInfo.getSQLType(pgElementOid), Optional.of(typeInfo.getPGType(pgElementOid)), arrayTypeHandle.columnSize(), arrayTypeHandle.decimalDigits(), Optional.empty(), Optional.empty());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static ColumnMapping typedVarcharColumnMapping(String jdbcTypeName) {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction(jdbcTypeName), (PredicatePushdownController)POSTGRESQL_STRING_COLLATION_AWARE_PUSHDOWN);
    }

    private static SliceWriteFunction typedVarcharWriteFunction(String jdbcTypeName) {
        Objects.requireNonNull(jdbcTypeName, "jdbcTypeName is null");
        String quotedJdbcTypeName = jdbcTypeName.startsWith("\"") && jdbcTypeName.endsWith("\"") ? jdbcTypeName : "\"%s\"".formatted(jdbcTypeName.replace("\"", "\"\""));
        final String bindExpression = String.format("CAST(? AS %s)", quotedJdbcTypeName);
        return new SliceWriteFunction(){

            public String getBindExpression() {
                return bindExpression;
            }

            public void set(PreparedStatement statement, int index, Slice value) throws SQLException {
                statement.setString(index, value.toStringUtf8());
            }
        };
    }

    private static ColumnMapping moneyColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (SliceReadFunction)new SliceReadFunction(){

            public boolean isNull(ResultSet resultSet, int columnIndex) throws SQLException {
                resultSet.getString(columnIndex);
                return resultSet.wasNull();
            }

            public Slice readSlice(ResultSet resultSet, int columnIndex) throws SQLException {
                return Slices.utf8Slice((String)resultSet.getString(columnIndex));
            }
        }, (statement, index, value) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Money type is not supported for INSERT");
        }, (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static SliceWriteFunction uuidWriteFunction() {
        return (statement, index, value) -> statement.setObject(index, (Object)UuidType.trinoUuidToJavaUuid((Slice)value), 1111);
    }

    private ColumnMapping uuidColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.uuidType, (resultSet, columnIndex) -> UuidType.javaUuidToTrinoUuid((UUID)((UUID)resultSet.getObject(columnIndex))), (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
    }

    private static ColumnMapping vectorColumnMapping() {
        return ColumnMapping.objectMapping((Type)new ArrayType((Type)RealType.REAL), (ObjectReadFunction)PostgreSqlClient.vectorReadFunction(), (ObjectWriteFunction)PostgreSqlClient.vectorWriteFunction(), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static ObjectReadFunction vectorReadFunction() {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            String result = resultSet.getString(columnIndex);
            if (result == null) {
                BlockBuilder builder = RealType.REAL.createBlockBuilder(null, 1);
                builder.appendNull();
                return builder.build();
            }
            Verify.verify((result.charAt(0) == '[' && result.charAt(result.length() - 1) == ']' ? 1 : 0) != 0, (String)"vector must be enclosed in square brackets: %s", (Object)result);
            String[] vectors = result.substring(1, result.length() - 1).split(",");
            BlockBuilder builder = RealType.REAL.createBlockBuilder(null, vectors.length);
            for (String vector : vectors) {
                RealType.REAL.writeFloat(builder, Float.parseFloat(vector));
            }
            return builder.build();
        });
    }

    private static ObjectWriteFunction vectorWriteFunction() {
        return ObjectWriteFunction.of(Block.class, (preparedStatement, n, block) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Writing to vector type is unsupported");
        });
    }

    private static class StatisticsDao {
        private final Handle handle;

        public StatisticsDao(Handle handle) {
            this.handle = Objects.requireNonNull(handle, "handle is null");
        }

        Optional<Long> getRowCountFromPgClass(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT reltuples FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = :schema) AND relname = :table_name").bind("schema", schema)).bind("table_name", tableName)).mapTo(Long.class).findOne();
        }

        Optional<Long> getRowCountFromPgStat(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT n_live_tup FROM pg_stat_all_tables WHERE schemaname = :schema AND relname = :table_name").bind("schema", schema)).bind("table_name", tableName)).mapTo(Long.class).findOne();
        }

        Optional<Long> getRowCountPartitionedTableFromPgClass(String schema, String tableName) {
            return ((Query)this.handle.createQuery("SELECT SUM(child.reltuples) FROM pg_inherits JOIN pg_class parent ON pg_inherits.inhparent = parent.oid JOIN pg_class child ON pg_inherits.inhrelid = child.oid JOIN pg_namespace parent_ns ON parent_ns.oid = parent.relnamespace JOIN pg_namespace child_ns ON child_ns.oid = child.relnamespace WHERE parent.oid = :schema_table_name::regclass").bind("schema_table_name", String.format("%s.%s", schema, tableName))).mapTo(Long.class).findOne();
        }

        Optional<Long> getRowCountPartitionedTableFromPgStats(String schema, String tableName) {
            return ((Query)this.handle.createQuery("SELECT SUM(stat.n_live_tup) FROM pg_inherits JOIN pg_class parent ON pg_inherits.inhparent = parent.oid JOIN pg_class child ON pg_inherits.inhrelid = child.oid JOIN pg_namespace parent_ns ON parent_ns.oid = parent.relnamespace JOIN pg_namespace child_ns ON child_ns.oid = child.relnamespace JOIN pg_stat_all_tables stat ON stat.schemaname = child_ns.nspname AND stat.relname = child.relname WHERE parent.oid = :schema_table_name::regclass").bind("schema_table_name", String.format("%s.%s", schema, tableName))).mapTo(Long.class).findOne();
        }

        List<ColumnStatisticsResult> getColumnStatistics(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT attname, null_frac, n_distinct, avg_width FROM pg_stats WHERE schemaname = :schema AND tablename = :table_name").bind("schema", schema)).bind("table_name", tableName)).map((rs, ctx) -> new ColumnStatisticsResult(Objects.requireNonNull(rs.getString("attname"), "attname is null"), Optional.ofNullable(rs.getObject("null_frac", Float.class)), Optional.ofNullable(rs.getObject("n_distinct", Float.class)), Optional.ofNullable(rs.getObject("avg_width", Integer.class)))).list();
        }

        boolean isPartitionedTable(String schema, String tableName) {
            return ((Query)((Query)this.handle.createQuery("SELECT true FROM pg_class WHERE relnamespace = (SELECT oid FROM pg_namespace WHERE nspname = :schema) AND relname = :table_name AND relkind = 'p'").bind("schema", schema)).bind("table_name", tableName)).mapTo(Boolean.class).findOne().orElse(false);
        }
    }

    private static class ColumnStatisticsResult {
        private final String columnName;
        private final Optional<Float> nullsFraction;
        private final Optional<Float> distinctValuesIndicator;
        private final Optional<Integer> averageColumnLength;

        public ColumnStatisticsResult(String columnName, Optional<Float> nullsFraction, Optional<Float> distinctValuesIndicator, Optional<Integer> averageColumnLength) {
            this.columnName = columnName;
            this.nullsFraction = nullsFraction;
            this.distinctValuesIndicator = distinctValuesIndicator;
            this.averageColumnLength = averageColumnLength;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public Optional<Float> getNullsFraction() {
            return this.nullsFraction;
        }

        public Optional<Float> getDistinctValuesIndicator() {
            return this.distinctValuesIndicator;
        }

        public Optional<Integer> getAverageColumnLength() {
            return this.averageColumnLength;
        }
    }
}

