/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.jdbc.DecimalModule;
import io.trino.plugin.jdbc.ForBaseJdbc;
import io.trino.plugin.jdbc.JdbcClient;
import io.trino.plugin.jdbc.JdbcJoinPushdownSupportModule;
import io.trino.plugin.jdbc.JdbcModule;
import io.trino.plugin.jdbc.JdbcStatisticsConfig;
import io.trino.plugin.jdbc.QueryBuilder;
import io.trino.plugin.jdbc.RemoteQueryCancellationModule;
import io.trino.plugin.jdbc.TimestampTimeZoneDomain;
import io.trino.plugin.jdbc.ptf.Query;
import io.trino.plugin.postgresql.CollationAwareQueryBuilder;
import io.trino.plugin.postgresql.PostgreSqlClient;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlSessionProperties;
import io.trino.spi.function.table.ConnectorTableFunction;

public class PostgreSqlClientModule
extends AbstractConfigurationAwareModule {
    public void setup(Binder binder) {
        binder.bind(JdbcClient.class).annotatedWith(ForBaseJdbc.class).to(PostgreSqlClient.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, TimestampTimeZoneDomain.class).setBinding().toInstance((Object)TimestampTimeZoneDomain.UTC_ONLY);
        ConfigBinder.configBinder((Binder)binder).bindConfig(PostgreSqlConfig.class);
        ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcStatisticsConfig.class);
        JdbcModule.bindSessionPropertiesProvider((Binder)binder, PostgreSqlSessionProperties.class);
        OptionalBinder.newOptionalBinder((Binder)binder, QueryBuilder.class).setBinding().to(CollationAwareQueryBuilder.class).in(Scopes.SINGLETON);
        this.install((Module)new DecimalModule());
        this.install((Module)new JdbcJoinPushdownSupportModule());
        this.install((Module)new RemoteQueryCancellationModule());
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(Query.class).in(Scopes.SINGLETON);
    }
}

