/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public final class PostgreSqlSessionProperties
implements SessionPropertiesProvider {
    public static final String ARRAY_MAPPING = "array_mapping";
    public static final String ENABLE_STRING_PUSHDOWN_WITH_COLLATE = "enable_string_pushdown_with_collate";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public PostgreSqlSessionProperties(PostgreSqlConfig postgreSqlConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.enumProperty((String)ARRAY_MAPPING, (String)"Handling of PostgreSql arrays", PostgreSqlConfig.ArrayMapping.class, (Enum)postgreSqlConfig.getArrayMapping(), (boolean)false), (Object)PropertyMetadata.booleanProperty((String)ENABLE_STRING_PUSHDOWN_WITH_COLLATE, (String)"Enable string pushdown with collate (experimental)", (Boolean)postgreSqlConfig.isEnableStringPushdownWithCollate(), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static PostgreSqlConfig.ArrayMapping getArrayMapping(ConnectorSession session) {
        return (PostgreSqlConfig.ArrayMapping)((Object)session.getProperty(ARRAY_MAPPING, PostgreSqlConfig.ArrayMapping.class));
    }

    public static boolean isEnableStringPushdownWithCollate(ConnectorSession session) {
        return (Boolean)session.getProperty(ENABLE_STRING_PUSHDOWN_WITH_COLLATE, Boolean.class);
    }
}

