/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.postgresql;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.math.LongMath;
import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonTypeUtil;
import io.trino.plugin.jdbc.BaseJdbcClient;
import io.trino.plugin.jdbc.BaseJdbcConfig;
import io.trino.plugin.jdbc.BooleanReadFunction;
import io.trino.plugin.jdbc.BooleanWriteFunction;
import io.trino.plugin.jdbc.ColumnMapping;
import io.trino.plugin.jdbc.ConnectionFactory;
import io.trino.plugin.jdbc.DecimalConfig;
import io.trino.plugin.jdbc.DecimalSessionSessionProperties;
import io.trino.plugin.jdbc.DoubleReadFunction;
import io.trino.plugin.jdbc.DoubleWriteFunction;
import io.trino.plugin.jdbc.JdbcColumnHandle;
import io.trino.plugin.jdbc.JdbcErrorCode;
import io.trino.plugin.jdbc.JdbcExpression;
import io.trino.plugin.jdbc.JdbcJoinCondition;
import io.trino.plugin.jdbc.JdbcSortItem;
import io.trino.plugin.jdbc.JdbcTableHandle;
import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.LongReadFunction;
import io.trino.plugin.jdbc.LongWriteFunction;
import io.trino.plugin.jdbc.ObjectReadFunction;
import io.trino.plugin.jdbc.ObjectWriteFunction;
import io.trino.plugin.jdbc.PredicatePushdownController;
import io.trino.plugin.jdbc.ReadFunction;
import io.trino.plugin.jdbc.SliceReadFunction;
import io.trino.plugin.jdbc.SliceWriteFunction;
import io.trino.plugin.jdbc.StandardColumnMappings;
import io.trino.plugin.jdbc.TypeHandlingJdbcSessionProperties;
import io.trino.plugin.jdbc.UnsupportedTypeHandling;
import io.trino.plugin.jdbc.WriteMapping;
import io.trino.plugin.jdbc.expression.AggregateFunctionRewriter;
import io.trino.plugin.jdbc.expression.ImplementAvgDecimal;
import io.trino.plugin.jdbc.expression.ImplementAvgFloatingPoint;
import io.trino.plugin.jdbc.expression.ImplementCorr;
import io.trino.plugin.jdbc.expression.ImplementCount;
import io.trino.plugin.jdbc.expression.ImplementCountAll;
import io.trino.plugin.jdbc.expression.ImplementCovariancePop;
import io.trino.plugin.jdbc.expression.ImplementCovarianceSamp;
import io.trino.plugin.jdbc.expression.ImplementMinMax;
import io.trino.plugin.jdbc.expression.ImplementRegrIntercept;
import io.trino.plugin.jdbc.expression.ImplementRegrSlope;
import io.trino.plugin.jdbc.expression.ImplementStddevPop;
import io.trino.plugin.jdbc.expression.ImplementStddevSamp;
import io.trino.plugin.jdbc.expression.ImplementSum;
import io.trino.plugin.jdbc.expression.ImplementVariancePop;
import io.trino.plugin.jdbc.expression.ImplementVarianceSamp;
import io.trino.plugin.postgresql.ImplementAvgBigint;
import io.trino.plugin.postgresql.PostgreSqlConfig;
import io.trino.plugin.postgresql.PostgreSqlSessionProperties;
import io.trino.plugin.postgresql.TypeUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.JoinCondition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.postgresql.core.TypeInfo;
import org.postgresql.jdbc.PgConnection;

public class PostgreSqlClient
extends BaseJdbcClient {
    private static final Logger log = Logger.get(PostgreSqlClient.class);
    private static final int ARRAY_RESULT_SET_VALUE_COLUMN = 2;
    private static final String DUPLICATE_TABLE_SQLSTATE = "42P07";
    private static final int POSTGRESQL_MAX_SUPPORTED_TIMESTAMP_PRECISION = 6;
    private static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSSSSS");
    private final Type jsonType;
    private final Type uuidType;
    private final MapType varcharMapType;
    private final List<String> tableTypes;
    private final AggregateFunctionRewriter aggregateFunctionRewriter;
    private static final PredicatePushdownController POSTGRESQL_CHARACTER_PUSHDOWN = (session, domain) -> {
        Preconditions.checkArgument((domain.getType() instanceof VarcharType || domain.getType() instanceof CharType ? 1 : 0) != 0, (Object)"This PredicatePushdownController can be used only for chars and varchars");
        if (domain.isOnlyNull() || domain.getValues().isDiscreteSet()) {
            return PredicatePushdownController.FULL_PUSHDOWN.apply(session, domain);
        }
        return PredicatePushdownController.DISABLE_PUSHDOWN.apply(session, domain);
    };

    @Inject
    public PostgreSqlClient(BaseJdbcConfig config, PostgreSqlConfig postgreSqlConfig, ConnectionFactory connectionFactory, TypeManager typeManager) {
        super(config, "\"", connectionFactory);
        this.jsonType = typeManager.getType(new TypeSignature("json", new TypeSignatureParameter[0]));
        this.uuidType = typeManager.getType(new TypeSignature("uuid", new TypeSignatureParameter[0]));
        this.varcharMapType = (MapType)typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
        ImmutableList.Builder tableTypes = ImmutableList.builder();
        tableTypes.add((Object[])new String[]{"TABLE", "VIEW", "MATERIALIZED VIEW", "FOREIGN TABLE"});
        if (postgreSqlConfig.isIncludeSystemTables()) {
            tableTypes.add((Object[])new String[]{"SYSTEM TABLE", "SYSTEM VIEW"});
        }
        this.tableTypes = tableTypes.build();
        JdbcTypeHandle bigintTypeHandle = new JdbcTypeHandle(-5, Optional.of("bigint"), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(arg_0 -> ((PostgreSqlClient)this).quoted(arg_0), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll(bigintTypeHandle)).add((Object)new ImplementCount(bigintTypeHandle)).add((Object)new ImplementMinMax()).add((Object)new ImplementSum(PostgreSqlClient::toTypeHandle)).add((Object)new ImplementAvgFloatingPoint()).add((Object)new ImplementAvgDecimal()).add((Object)new ImplementAvgBigint()).add((Object)new ImplementStddevSamp()).add((Object)new ImplementStddevPop()).add((Object)new ImplementVarianceSamp()).add((Object)new ImplementVariancePop()).add((Object)new ImplementCovarianceSamp()).add((Object)new ImplementCovariancePop()).add((Object)new ImplementCorr()).add((Object)new ImplementRegrIntercept()).add((Object)new ImplementRegrSlope()).build());
    }

    public void createTable(ConnectorSession session, ConnectorTableMetadata tableMetadata) {
        try {
            this.createTable(session, tableMetadata, tableMetadata.getTable().getTableName());
        }
        catch (SQLException e) {
            boolean exists = DUPLICATE_TABLE_SQLSTATE.equals(e.getSQLState());
            throw new TrinoException((ErrorCodeSupplier)(exists ? StandardErrorCode.ALREADY_EXISTS : JdbcErrorCode.JDBC_ERROR), (Throwable)e);
        }
    }

    protected void renameTable(ConnectorSession session, String catalogName, String schemaName, String tableName, SchemaTableName newTable) {
        if (!schemaName.equals(newTable.getSchemaName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support renaming tables across schemas");
        }
        String sql = String.format("ALTER TABLE %s RENAME TO %s", this.quoted(catalogName, schemaName, tableName), this.quoted(newTable.getTableName()));
        this.execute(session, sql);
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        connection.setAutoCommit(false);
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setFetchSize(1000);
        return statement;
    }

    protected Optional<List<String>> getTableTypes() {
        return Optional.of(this.tableTypes);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<JdbcColumnHandle> getColumns(ConnectorSession session, JdbcTableHandle tableHandle) {
        if (tableHandle.getColumns().isPresent()) {
            return (List)tableHandle.getColumns().get();
        }
        Preconditions.checkArgument((boolean)tableHandle.isNamedRelation(), (String)"Cannot get columns for %s", (Object)tableHandle);
        SchemaTableName schemaTableName = tableHandle.getRequiredNamedRelation().getSchemaTableName();
        try (Connection connection = this.connectionFactory.openConnection(session);){
            ImmutableList immutableList;
            block19: {
                Object arrayColumnDimensions = ImmutableMap.of();
                if (PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
                    arrayColumnDimensions = PostgreSqlClient.getArrayColumnDimensions(connection, tableHandle);
                }
                ResultSet resultSet = this.getColumns(tableHandle, connection.getMetaData());
                try {
                    int allColumns = 0;
                    ArrayList<JdbcColumnHandle> columns = new ArrayList<JdbcColumnHandle>();
                    while (resultSet.next()) {
                        ++allColumns;
                        String columnName = resultSet.getString("COLUMN_NAME");
                        JdbcTypeHandle typeHandle = new JdbcTypeHandle(((Integer)PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"DATA_TYPE").orElseThrow(() -> new IllegalStateException("DATA_TYPE is null"))).intValue(), Optional.of(resultSet.getString("TYPE_NAME")), PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"COLUMN_SIZE"), PostgreSqlClient.getInteger((ResultSet)resultSet, (String)"DECIMAL_DIGITS"), Optional.ofNullable((Integer)arrayColumnDimensions.get(columnName)), Optional.empty());
                        Optional<ColumnMapping> columnMapping = this.toColumnMapping(session, connection, typeHandle);
                        log.debug("Mapping data type of '%s' column '%s': %s mapped to %s", new Object[]{schemaTableName, columnName, typeHandle, columnMapping});
                        if (columnMapping.isPresent()) {
                            boolean nullable = resultSet.getInt("NULLABLE") != 0;
                            Optional<String> comment = Optional.ofNullable(resultSet.getString("REMARKS"));
                            columns.add(JdbcColumnHandle.builder().setColumnName(columnName).setJdbcTypeHandle(typeHandle).setColumnType(columnMapping.get().getType()).setNullable(nullable).setComment(comment).build());
                        }
                        if (!columnMapping.isEmpty()) continue;
                        UnsupportedTypeHandling unsupportedTypeHandling = TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session);
                        Verify.verify((unsupportedTypeHandling == UnsupportedTypeHandling.IGNORE ? 1 : 0) != 0, (String)"Unsupported type handling is set to %s, but toTrinoType() returned empty for %s", (Object)unsupportedTypeHandling, (Object)typeHandle);
                    }
                    if (columns.isEmpty()) {
                        throw new TableNotFoundException(tableHandle.getSchemaTableName(), String.format("Table '%s' has no supported columns (all %s columns are not supported)", tableHandle.getSchemaTableName(), allColumns));
                    }
                    immutableList = ImmutableList.copyOf(columns);
                    if (resultSet == null) break block19;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return immutableList;
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private static Map<String, Integer> getArrayColumnDimensions(Connection connection, JdbcTableHandle tableHandle) throws SQLException {
        String sql = "SELECT att.attname, greatest(att.attndims, 1) AS attndims FROM pg_attribute att   JOIN pg_type attyp ON att.atttypid = attyp.oid  JOIN pg_class tbl ON tbl.oid = att.attrelid   JOIN pg_namespace ns ON tbl.relnamespace = ns.oid WHERE ns.nspname = ? AND tbl.relname = ? AND attyp.typcategory = 'A' ";
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, tableHandle.getSchemaName());
            statement.setString(2, tableHandle.getTableName());
            HashMap<String, Integer> arrayColumnDimensions = new HashMap<String, Integer>();
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    arrayColumnDimensions.put(resultSet.getString("attname"), resultSet.getInt("attndims"));
                }
            }
            HashMap<String, Integer> hashMap = arrayColumnDimensions;
            return hashMap;
        }
    }

    public Optional<ColumnMapping> toColumnMapping(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        String jdbcTypeName = (String)typeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + typeHandle));
        Optional mapping = this.getForcedMappingToVarchar(typeHandle);
        if (mapping.isPresent()) {
            return mapping;
        }
        switch (jdbcTypeName) {
            case "money": {
                return Optional.of(PostgreSqlClient.moneyColumnMapping());
            }
            case "uuid": {
                return Optional.of(this.uuidColumnMapping());
            }
            case "jsonb": 
            case "json": {
                return Optional.of(this.jsonColumnMapping());
            }
            case "timestamptz": {
                int decimalDigits = typeHandle.getRequiredDecimalDigits();
                return Optional.of(PostgreSqlClient.timestampWithTimeZoneColumnMapping(decimalDigits));
            }
            case "hstore": {
                return Optional.of(this.hstoreColumnMapping(session));
            }
        }
        switch (typeHandle.getJdbcType()) {
            case -7: {
                return Optional.of(StandardColumnMappings.booleanColumnMapping());
            }
            case 5: {
                return Optional.of(StandardColumnMappings.smallintColumnMapping());
            }
            case 4: {
                return Optional.of(StandardColumnMappings.integerColumnMapping());
            }
            case -5: {
                return Optional.of(StandardColumnMappings.bigintColumnMapping());
            }
            case 7: {
                return Optional.of(StandardColumnMappings.realColumnMapping());
            }
            case 8: {
                return Optional.of(StandardColumnMappings.doubleColumnMapping());
            }
            case 2: {
                int precision;
                int columnSize = typeHandle.getRequiredColumnSize();
                int decimalDigits = (Integer)typeHandle.getDecimalDigits().orElseThrow(() -> new IllegalStateException("decimal digits not present"));
                if (DecimalSessionSessionProperties.getDecimalRounding((ConnectorSession)session) == DecimalConfig.DecimalMapping.ALLOW_OVERFLOW) {
                    if (columnSize == 131089) {
                        return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session)), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                    }
                    precision = columnSize;
                    if (precision > 38) {
                        int scale = Math.min(decimalDigits, DecimalSessionSessionProperties.getDecimalDefaultScale((ConnectorSession)session));
                        return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)38, (int)scale), (RoundingMode)DecimalSessionSessionProperties.getDecimalRoundingMode((ConnectorSession)session)));
                    }
                }
                if ((precision = columnSize + Math.max(-decimalDigits, 0)) > 38) break;
                return Optional.of(StandardColumnMappings.decimalColumnMapping((DecimalType)DecimalType.createDecimalType((int)precision, (int)Math.max(decimalDigits, 0)), (RoundingMode)RoundingMode.UNNECESSARY));
            }
            case 1: {
                return Optional.of(PostgreSqlClient.charColumnMapping(typeHandle.getRequiredColumnSize()));
            }
            case 12: {
                if (!jdbcTypeName.equals("varchar")) {
                    return Optional.of(PostgreSqlClient.typedVarcharColumnMapping(jdbcTypeName));
                }
                return Optional.of(PostgreSqlClient.varcharColumnMapping(typeHandle.getRequiredColumnSize()));
            }
            case -2: {
                return Optional.of(StandardColumnMappings.varbinaryColumnMapping());
            }
            case 91: {
                return Optional.of(StandardColumnMappings.dateColumnMapping());
            }
            case 92: {
                return Optional.of(PostgreSqlClient.timeColumnMapping(typeHandle.getRequiredDecimalDigits()));
            }
            case 93: {
                TimestampType timestampType = TimestampType.createTimestampType((int)typeHandle.getRequiredDecimalDigits());
                return Optional.of(ColumnMapping.longMapping((Type)timestampType, (LongReadFunction)StandardColumnMappings.timestampReadFunction((TimestampType)timestampType), PostgreSqlClient::shortTimestampWriteFunction));
            }
            case 2003: {
                Optional<ColumnMapping> columnMapping = this.arrayToPrestoType(session, connection, typeHandle);
                if (!columnMapping.isPresent()) break;
                return columnMapping;
            }
        }
        if (TypeHandlingJdbcSessionProperties.getUnsupportedTypeHandling((ConnectorSession)session) == UnsupportedTypeHandling.CONVERT_TO_VARCHAR) {
            return PostgreSqlClient.mapToUnboundedVarchar((JdbcTypeHandle)typeHandle);
        }
        return Optional.empty();
    }

    private Optional<ColumnMapping> arrayToPrestoType(ConnectorSession session, Connection connection, JdbcTypeHandle typeHandle) {
        Preconditions.checkArgument((typeHandle.getJdbcType() == 2003 ? 1 : 0) != 0, (Object)"Not array type");
        PostgreSqlConfig.ArrayMapping arrayMapping = PostgreSqlSessionProperties.getArrayMapping(session);
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.DISABLED) {
            return Optional.empty();
        }
        JdbcTypeHandle baseElementTypeHandle = PostgreSqlClient.getArrayElementTypeHandle(connection, typeHandle);
        String baseElementTypeName = (String)baseElementTypeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Element type name is missing: " + baseElementTypeHandle));
        if (baseElementTypeHandle.getJdbcType() == -2) {
            return Optional.empty();
        }
        Optional<ColumnMapping> baseElementMapping = this.toColumnMapping(session, connection, baseElementTypeHandle);
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
            if (typeHandle.getArrayDimensions().isEmpty()) {
                return Optional.empty();
            }
            return baseElementMapping.map(elementMapping -> {
                ArrayType prestoArrayType = new ArrayType(elementMapping.getType());
                ColumnMapping arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, elementMapping, baseElementTypeName);
                int arrayDimensions = (Integer)typeHandle.getArrayDimensions().get();
                for (int i = 1; i < arrayDimensions; ++i) {
                    prestoArrayType = new ArrayType((Type)prestoArrayType);
                    arrayColumnMapping = PostgreSqlClient.arrayColumnMapping(session, prestoArrayType, arrayColumnMapping, baseElementTypeName);
                }
                return arrayColumnMapping;
            });
        }
        if (arrayMapping == PostgreSqlConfig.ArrayMapping.AS_JSON) {
            return baseElementMapping.map(elementMapping -> this.arrayAsJsonColumnMapping(session, (ColumnMapping)elementMapping));
        }
        throw new IllegalStateException("Unsupported array mapping type: " + arrayMapping);
    }

    public WriteMapping toWriteMapping(ConnectorSession session, Type type) {
        if (type == BooleanType.BOOLEAN) {
            return WriteMapping.booleanMapping((String)"boolean", (BooleanWriteFunction)StandardColumnMappings.booleanWriteFunction());
        }
        if (type == TinyintType.TINYINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.tinyintWriteFunction());
        }
        if (type == SmallintType.SMALLINT) {
            return WriteMapping.longMapping((String)"smallint", (LongWriteFunction)StandardColumnMappings.smallintWriteFunction());
        }
        if (type == IntegerType.INTEGER) {
            return WriteMapping.longMapping((String)"integer", (LongWriteFunction)StandardColumnMappings.integerWriteFunction());
        }
        if (type == BigintType.BIGINT) {
            return WriteMapping.longMapping((String)"bigint", (LongWriteFunction)StandardColumnMappings.bigintWriteFunction());
        }
        if (type == RealType.REAL) {
            return WriteMapping.longMapping((String)"real", (LongWriteFunction)StandardColumnMappings.realWriteFunction());
        }
        if (type == DoubleType.DOUBLE) {
            return WriteMapping.doubleMapping((String)"double precision", (DoubleWriteFunction)StandardColumnMappings.doubleWriteFunction());
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            String dataType = String.format("decimal(%s, %s)", decimalType.getPrecision(), decimalType.getScale());
            if (decimalType.isShort()) {
                return WriteMapping.longMapping((String)dataType, (LongWriteFunction)StandardColumnMappings.shortDecimalWriteFunction((DecimalType)decimalType));
            }
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.longDecimalWriteFunction((DecimalType)decimalType));
        }
        if (type instanceof CharType) {
            return WriteMapping.sliceMapping((String)("char(" + ((CharType)type).getLength() + ")"), (SliceWriteFunction)StandardColumnMappings.charWriteFunction());
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            Object dataType = varcharType.isUnbounded() ? "varchar" : "varchar(" + varcharType.getBoundedLength() + ")";
            return WriteMapping.sliceMapping((String)dataType, (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction());
        }
        if (VarbinaryType.VARBINARY.equals((Object)type)) {
            return WriteMapping.sliceMapping((String)"bytea", (SliceWriteFunction)StandardColumnMappings.varbinaryWriteFunction());
        }
        if (type == DateType.DATE) {
            return WriteMapping.longMapping((String)"date", (LongWriteFunction)StandardColumnMappings.dateWriteFunction());
        }
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            if (timeType.getPrecision() <= 6) {
                return WriteMapping.longMapping((String)String.format("time(%s)", timeType.getPrecision()), (LongWriteFunction)PostgreSqlClient.timeWriteFunction(timeType.getPrecision()));
            }
            return WriteMapping.longMapping((String)String.format("time(%s)", 6), (LongWriteFunction)PostgreSqlClient.timeWriteFunction(6));
        }
        if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            if (timestampType.getPrecision() <= 6) {
                Verify.verify((timestampType.getPrecision() <= 6 ? 1 : 0) != 0);
                return WriteMapping.longMapping((String)String.format("timestamp(%s)", timestampType.getPrecision()), PostgreSqlClient::shortTimestampWriteFunction);
            }
            Verify.verify((timestampType.getPrecision() > 6 ? 1 : 0) != 0);
            return WriteMapping.objectMapping((String)String.format("timestamp(%s)", 6), (ObjectWriteFunction)PostgreSqlClient.longTimestampWriteFunction());
        }
        if (type instanceof TimestampWithTimeZoneType) {
            TimestampWithTimeZoneType timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
            if (timestampWithTimeZoneType.getPrecision() <= 6) {
                String dataType = String.format("timestamptz(%d)", timestampWithTimeZoneType.getPrecision());
                if (timestampWithTimeZoneType.getPrecision() <= 3) {
                    return WriteMapping.longMapping((String)dataType, (LongWriteFunction)PostgreSqlClient.shortTimestampWithTimeZoneWriteFunction());
                }
                return WriteMapping.objectMapping((String)dataType, (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
            }
            return WriteMapping.objectMapping((String)String.format("timestamptz(%d)", 6), (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
        }
        if (type.equals(this.jsonType)) {
            return WriteMapping.sliceMapping((String)"jsonb", (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"));
        }
        if (type.equals(this.uuidType)) {
            return WriteMapping.sliceMapping((String)"uuid", (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
        }
        if (type instanceof ArrayType && PostgreSqlSessionProperties.getArrayMapping(session) == PostgreSqlConfig.ArrayMapping.AS_ARRAY) {
            Type elementType = ((ArrayType)type).getElementType();
            String elementDataType = this.toWriteMapping(session, elementType).getDataType();
            return WriteMapping.objectMapping((String)(elementDataType + "[]"), (ObjectWriteFunction)PostgreSqlClient.arrayWriteFunction(session, elementType, TypeUtils.getArrayElementPgTypeName(session, this, elementType)));
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported column type: " + type.getDisplayName());
    }

    public Optional<JdbcExpression> implementAggregation(ConnectorSession session, AggregateFunction aggregate, Map<String, ColumnHandle> assignments) {
        return this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
    }

    private static Optional<JdbcTypeHandle> toTypeHandle(DecimalType decimalType) {
        return Optional.of(new JdbcTypeHandle(2, Optional.of("decimal"), Optional.of(decimalType.getPrecision()), Optional.of(decimalType.getScale()), Optional.empty(), Optional.empty()));
    }

    public boolean supportsTopN(ConnectorSession session, JdbcTableHandle handle, List<JdbcSortItem> sortOrder) {
        for (JdbcSortItem sortItem : sortOrder) {
            Type sortItemType = sortItem.getColumn().getColumnType();
            if (!(sortItemType instanceof CharType) && !(sortItemType instanceof VarcharType) || this.isCollatable(sortItem.getColumn())) continue;
            return false;
        }
        return true;
    }

    protected Optional<BaseJdbcClient.TopNFunction> topNFunction() {
        return Optional.of((query, sortItems, limit) -> {
            String orderBy = sortItems.stream().map(sortItem -> {
                String ordering = sortItem.getSortOrder().isAscending() ? "ASC" : "DESC";
                String nullsHandling = sortItem.getSortOrder().isNullsFirst() ? "NULLS FIRST" : "NULLS LAST";
                String collation = "";
                if (this.isCollatable(sortItem.getColumn())) {
                    collation = "COLLATE \"C\"";
                }
                return String.format("%s %s %s %s", this.quoted(sortItem.getColumn().getColumnName()), collation, ordering, nullsHandling);
            }).collect(Collectors.joining(", "));
            return String.format("%s ORDER BY %s LIMIT %d", query, orderBy, limit);
        });
    }

    private boolean isCollatable(JdbcColumnHandle column) {
        if (column.getColumnType() instanceof CharType || column.getColumnType() instanceof VarcharType) {
            String jdbcTypeName = (String)column.getJdbcTypeHandle().getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + column.getJdbcTypeHandle()));
            return "bpchar".equals(jdbcTypeName) || "varchar".equals(jdbcTypeName) || "text".equals(jdbcTypeName);
        }
        return false;
    }

    public boolean isTopNLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    protected Optional<BiFunction<String, Long, String>> limitFunction() {
        return Optional.of((sql, limit) -> sql + " LIMIT " + limit);
    }

    public boolean isLimitGuaranteed(ConnectorSession session) {
        return true;
    }

    protected boolean isSupportedJoinCondition(JdbcJoinCondition joinCondition) {
        boolean isVarchar = Stream.of(joinCondition.getLeftColumn(), joinCondition.getRightColumn()).map(JdbcColumnHandle::getColumnType).anyMatch(type -> type instanceof CharType || type instanceof VarcharType);
        if (isVarchar) {
            JoinCondition.Operator operator = joinCondition.getOperator();
            switch (operator) {
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    break;
                }
                case EQUAL: 
                case NOT_EQUAL: 
                case IS_DISTINCT_FROM: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static ColumnMapping charColumnMapping(int charLength) {
        if (charLength > 65536) {
            return PostgreSqlClient.varcharColumnMapping(charLength);
        }
        CharType charType = CharType.createCharType((long)charLength);
        return ColumnMapping.sliceMapping((Type)charType, (SliceReadFunction)StandardColumnMappings.charReadFunction((CharType)charType), (SliceWriteFunction)StandardColumnMappings.charWriteFunction(), (PredicatePushdownController)POSTGRESQL_CHARACTER_PUSHDOWN);
    }

    private static ColumnMapping varcharColumnMapping(int varcharLength) {
        VarcharType varcharType = varcharLength <= 0x7FFFFFFE ? VarcharType.createVarcharType((int)varcharLength) : VarcharType.createUnboundedVarcharType();
        return ColumnMapping.sliceMapping((Type)varcharType, (SliceReadFunction)StandardColumnMappings.varcharReadFunction((VarcharType)varcharType), (SliceWriteFunction)StandardColumnMappings.varcharWriteFunction(), (PredicatePushdownController)POSTGRESQL_CHARACTER_PUSHDOWN);
    }

    private static ColumnMapping timeColumnMapping(int precision) {
        Verify.verify((precision <= 6 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        return ColumnMapping.longMapping((Type)TimeType.createTimeType((int)precision), (resultSet, columnIndex) -> {
            LocalTime time = resultSet.getObject(columnIndex, LocalTime.class);
            long nanosOfDay = time.toNanoOfDay();
            if (nanosOfDay == 86399999999999L) {
                nanosOfDay = 86400000000000L - LongMath.pow((long)10L, (int)(9 - precision));
            }
            long picosOfDay = nanosOfDay * 1000L;
            return Timestamps.round((long)picosOfDay, (int)(12 - precision));
        }, (LongWriteFunction)PostgreSqlClient.timeWriteFunction(precision), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    public static LongWriteFunction timeWriteFunction(final int precision) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (String)"Unsupported precision: %s", (int)precision);
        final String bindExpression = String.format("CAST(? AS time(%s))", precision);
        return new LongWriteFunction(){

            public String getBindExpression() {
                return bindExpression;
            }

            public void set(PreparedStatement statement, int index, long picosOfDay) throws SQLException {
                if ((picosOfDay = Timestamps.round((long)picosOfDay, (int)(12 - precision))) == 86400000000000000L) {
                    picosOfDay = 0L;
                }
                LocalTime localTime = LocalTime.ofNanoOfDay(picosOfDay / 1000L);
                statement.setString(index, TIME_FORMATTER.format(localTime));
            }
        };
    }

    private static void shortTimestampWriteFunction(PreparedStatement statement, int index, long epochMicros) throws SQLException {
        LocalDateTime localDateTime = StandardColumnMappings.fromTrinoTimestamp((long)epochMicros);
        statement.setObject(index, TypeUtils.toPgTimestamp(localDateTime));
    }

    private static ObjectWriteFunction longTimestampWriteFunction() {
        return ObjectWriteFunction.of(LongTimestamp.class, (statement, index, timestamp) -> {
            Verify.verify((boolean)true);
            long epochMicros = timestamp.getEpochMicros();
            if (timestamp.getPicosOfMicro() >= 500000) {
                ++epochMicros;
            }
            PostgreSqlClient.shortTimestampWriteFunction(statement, index, epochMicros);
        });
    }

    public void setColumnComment(ConnectorSession session, JdbcTableHandle handle, JdbcColumnHandle column, Optional<String> comment) {
        String sql = String.format("COMMENT ON COLUMN %s.%s IS %s", this.quoted(handle.asPlainTable().getRemoteTableName()), this.quoted(column.getColumnName()), comment.isPresent() ? String.format("'%s'", comment.get()) : "NULL");
        this.execute(session, sql);
    }

    private static ColumnMapping timestampWithTimeZoneColumnMapping(int precision) {
        Preconditions.checkArgument((precision <= 6 ? 1 : 0) != 0, (String)"unsupported precision value %s", (int)precision);
        TimestampWithTimeZoneType prestoType = TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)precision);
        if (precision <= 3) {
            return ColumnMapping.longMapping((Type)prestoType, (LongReadFunction)PostgreSqlClient.shortTimestampWithTimeZoneReadFunction(), (LongWriteFunction)PostgreSqlClient.shortTimestampWithTimeZoneWriteFunction());
        }
        return ColumnMapping.objectMapping((Type)prestoType, (ObjectReadFunction)PostgreSqlClient.longTimestampWithTimeZoneReadFunction(), (ObjectWriteFunction)PostgreSqlClient.longTimestampWithTimeZoneWriteFunction());
    }

    private static LongReadFunction shortTimestampWithTimeZoneReadFunction() {
        return (resultSet, columnIndex) -> {
            long millisUtc = resultSet.getTimestamp(columnIndex).getTime();
            return DateTimeEncoding.packDateTimeWithZone((long)millisUtc, (TimeZoneKey)TimeZoneKey.UTC_KEY);
        };
    }

    private static LongWriteFunction shortTimestampWithTimeZoneWriteFunction() {
        return (statement, index, value) -> {
            long millisUtc = DateTimeEncoding.unpackMillisUtc((long)value);
            statement.setTimestamp(index, new Timestamp(millisUtc));
        };
    }

    private static ObjectReadFunction longTimestampWithTimeZoneReadFunction() {
        return ObjectReadFunction.of(LongTimestampWithTimeZone.class, (resultSet, columnIndex) -> {
            OffsetDateTime offsetDateTime = resultSet.getObject(columnIndex, OffsetDateTime.class);
            return LongTimestampWithTimeZone.fromEpochSecondsAndFraction((long)offsetDateTime.toEpochSecond(), (long)((long)offsetDateTime.getNano() * 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
        });
    }

    private static ObjectWriteFunction longTimestampWithTimeZoneWriteFunction() {
        return ObjectWriteFunction.of(LongTimestampWithTimeZone.class, (statement, index, value) -> {
            long epochSeconds = value.getEpochMillis() / 1000L;
            long nanosOfSecond = value.getEpochMillis() % 1000L * 1000000L + (long)(value.getPicosOfMilli() / 1000);
            statement.setObject(index, OffsetDateTime.ofInstant(Instant.ofEpochSecond(epochSeconds, nanosOfSecond), TimeZoneKey.UTC_KEY.getZoneId()));
        });
    }

    private ColumnMapping hstoreColumnMapping(ConnectorSession session) {
        return ColumnMapping.objectMapping((Type)this.varcharMapType, (ObjectReadFunction)this.varcharMapReadFunction(), (ObjectWriteFunction)this.hstoreWriteFunction(session), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private ObjectReadFunction varcharMapReadFunction() {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Map map = (Map)resultSet.getObject(columnIndex);
            BlockBuilder keyBlockBuilder = this.varcharMapType.getKeyType().createBlockBuilder(null, map.size());
            BlockBuilder valueBlockBuilder = this.varcharMapType.getValueType().createBlockBuilder(null, map.size());
            for (Map.Entry entry : map.entrySet()) {
                if (entry.getKey() == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "hstore key is null");
                }
                this.varcharMapType.getKeyType().writeSlice(keyBlockBuilder, Slices.utf8Slice((String)((String)entry.getKey())));
                if (entry.getValue() == null) {
                    valueBlockBuilder.appendNull();
                    continue;
                }
                this.varcharMapType.getValueType().writeSlice(valueBlockBuilder, Slices.utf8Slice((String)((String)entry.getValue())));
            }
            return (Block)this.varcharMapType.createBlockFromKeyValue(Optional.empty(), new int[]{0, map.size()}, keyBlockBuilder.build(), valueBlockBuilder.build()).getObject(0, Block.class);
        });
    }

    private ObjectWriteFunction hstoreWriteFunction(ConnectorSession session) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Preconditions.checkArgument((boolean)(block instanceof SingleMapBlock), (String)"wrong block type: %s. expected SingleMapBlock", (Object)block.getClass().getSimpleName());
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (int i = 0; i < block.getPositionCount(); i += 2) {
                map.put(this.varcharMapType.getKeyType().getObjectValue(session, block, i), this.varcharMapType.getValueType().getObjectValue(session, block, i + 1));
            }
            statement.setObject(index, Collections.unmodifiableMap(map));
        });
    }

    private static ColumnMapping arrayColumnMapping(ConnectorSession session, ArrayType arrayType, ColumnMapping arrayElementMapping, String baseElementJdbcTypeName) {
        return ColumnMapping.objectMapping((Type)arrayType, (ObjectReadFunction)PostgreSqlClient.arrayReadFunction(arrayType.getElementType(), arrayElementMapping.getReadFunction()), (ObjectWriteFunction)PostgreSqlClient.arrayWriteFunction(session, arrayType.getElementType(), baseElementJdbcTypeName));
    }

    private static ObjectReadFunction arrayReadFunction(Type elementType, ReadFunction elementReadFunction) {
        return ObjectReadFunction.of(Block.class, (resultSet, columnIndex) -> {
            Array array = resultSet.getArray(columnIndex);
            BlockBuilder builder = elementType.createBlockBuilder(null, 10);
            try (ResultSet arrayAsResultSet = array.getResultSet();){
                while (arrayAsResultSet.next()) {
                    if (elementReadFunction.isNull(arrayAsResultSet, 2)) {
                        builder.appendNull();
                        continue;
                    }
                    if (elementType.getJavaType() == Boolean.TYPE) {
                        elementType.writeBoolean(builder, ((BooleanReadFunction)elementReadFunction).readBoolean(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Long.TYPE) {
                        elementType.writeLong(builder, ((LongReadFunction)elementReadFunction).readLong(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Double.TYPE) {
                        elementType.writeDouble(builder, ((DoubleReadFunction)elementReadFunction).readDouble(arrayAsResultSet, 2));
                        continue;
                    }
                    if (elementType.getJavaType() == Slice.class) {
                        elementType.writeSlice(builder, ((SliceReadFunction)elementReadFunction).readSlice(arrayAsResultSet, 2));
                        continue;
                    }
                    elementType.writeObject(builder, ((ObjectReadFunction)elementReadFunction).readObject(arrayAsResultSet, 2));
                }
            }
            return builder.build();
        });
    }

    private static ObjectWriteFunction arrayWriteFunction(ConnectorSession session, Type elementType, String baseElementJdbcTypeName) {
        return ObjectWriteFunction.of(Block.class, (statement, index, block) -> {
            Array jdbcArray = statement.getConnection().createArrayOf(baseElementJdbcTypeName, TypeUtils.getJdbcObjectArray(session, elementType, block));
            statement.setArray(index, jdbcArray);
        });
    }

    private ColumnMapping arrayAsJsonColumnMapping(ConnectorSession session, ColumnMapping baseElementMapping) {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (SliceReadFunction)PostgreSqlClient.arrayAsJsonReadFunction(session, baseElementMapping), (statement, index, block) -> {
            throw new UnsupportedOperationException();
        }, (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static SliceReadFunction arrayAsJsonReadFunction(ConnectorSession session, ColumnMapping baseElementMapping) {
        return (resultSet, columnIndex) -> {
            Object jdbcArray = resultSet.getArray(columnIndex).getArray();
            int arrayDimensions = TypeUtils.arrayDepth(jdbcArray);
            ReadFunction readFunction = baseElementMapping.getReadFunction();
            Type type = baseElementMapping.getType();
            for (int i = 0; i < arrayDimensions; ++i) {
                readFunction = PostgreSqlClient.arrayReadFunction(type, readFunction);
                type = new ArrayType(type);
            }
            Block block = (Block)((ObjectReadFunction)readFunction).readObject(resultSet, columnIndex);
            BlockBuilder builder = type.createBlockBuilder(null, 1);
            type.writeObject(builder, (Object)block);
            Object value = type.getObjectValue(session, builder.build(), 0);
            try {
                return JsonTypeUtil.toJsonValue((Object)value);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Conversion to JSON failed for  " + type.getDisplayName(), (Throwable)e);
            }
        };
    }

    private static JdbcTypeHandle getArrayElementTypeHandle(Connection connection, JdbcTypeHandle arrayTypeHandle) {
        String jdbcTypeName = (String)arrayTypeHandle.getJdbcTypeName().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, "Type name is missing: " + arrayTypeHandle));
        try {
            TypeInfo typeInfo = connection.unwrap(PgConnection.class).getTypeInfo();
            int pgElementOid = typeInfo.getPGArrayElement(typeInfo.getPGType(jdbcTypeName));
            Verify.verify((boolean)arrayTypeHandle.getCaseSensitivity().isEmpty(), (String)"Case sensitivity not supported", (Object[])new Object[0]);
            return new JdbcTypeHandle(typeInfo.getSQLType(pgElementOid), Optional.of(typeInfo.getPGType(pgElementOid)), arrayTypeHandle.getColumnSize(), arrayTypeHandle.getDecimalDigits(), arrayTypeHandle.getArrayDimensions(), Optional.empty());
        }
        catch (SQLException e) {
            throw new TrinoException((ErrorCodeSupplier)JdbcErrorCode.JDBC_ERROR, (Throwable)e);
        }
    }

    private ColumnMapping jsonColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.jsonType, (resultSet, columnIndex) -> JsonTypeUtil.jsonParse((Slice)Slices.utf8Slice((String)resultSet.getString(columnIndex))), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction("json"), (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static ColumnMapping typedVarcharColumnMapping(String jdbcTypeName) {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (resultSet, columnIndex) -> Slices.utf8Slice((String)resultSet.getString(columnIndex)), (SliceWriteFunction)PostgreSqlClient.typedVarcharWriteFunction(jdbcTypeName));
    }

    private static SliceWriteFunction typedVarcharWriteFunction(String jdbcTypeName) {
        final String bindExpression = String.format("CAST(? AS %s)", Objects.requireNonNull(jdbcTypeName, "jdbcTypeName is null"));
        return new SliceWriteFunction(){

            public String getBindExpression() {
                return bindExpression;
            }

            public void set(PreparedStatement statement, int index, Slice value) throws SQLException {
                statement.setString(index, value.toStringUtf8());
            }
        };
    }

    private static ColumnMapping moneyColumnMapping() {
        return ColumnMapping.sliceMapping((Type)VarcharType.VARCHAR, (SliceReadFunction)new SliceReadFunction(){

            public boolean isNull(ResultSet resultSet, int columnIndex) throws SQLException {
                resultSet.getString(columnIndex);
                return resultSet.wasNull();
            }

            public Slice readSlice(ResultSet resultSet, int columnIndex) throws SQLException {
                return Slices.utf8Slice((String)resultSet.getString(columnIndex));
            }
        }, (statement, index, value) -> {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Money type is not supported for INSERT");
        }, (PredicatePushdownController)PredicatePushdownController.DISABLE_PUSHDOWN);
    }

    private static SliceWriteFunction uuidWriteFunction() {
        return (statement, index, value) -> {
            long high = Long.reverseBytes(value.getLong(0));
            long low = Long.reverseBytes(value.getLong(8));
            UUID uuid = new UUID(high, low);
            statement.setObject(index, (Object)uuid, 1111);
        };
    }

    private static Slice uuidSlice(UUID uuid) {
        return Slices.wrappedLongArray((long[])new long[]{Long.reverseBytes(uuid.getMostSignificantBits()), Long.reverseBytes(uuid.getLeastSignificantBits())});
    }

    private ColumnMapping uuidColumnMapping() {
        return ColumnMapping.sliceMapping((Type)this.uuidType, (resultSet, columnIndex) -> PostgreSqlClient.uuidSlice((UUID)resultSet.getObject(columnIndex)), (SliceWriteFunction)PostgreSqlClient.uuidWriteFunction());
    }
}

