/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.expression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class ConnectorExpressions {
    private ConnectorExpressions() {
    }

    public static List<Variable> extractVariables(ConnectorExpression expression) {
        return (List)ConnectorExpressions.preOrder(expression).filter(Variable.class::isInstance).map(Variable.class::cast).collect(ImmutableList.toImmutableList());
    }

    public static List<ConnectorExpression> extractConjuncts(ConnectorExpression expression) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        ConnectorExpressions.extractConjuncts(expression, (ImmutableList.Builder<ConnectorExpression>)resultBuilder);
        return resultBuilder.build();
    }

    private static void extractConjuncts(ConnectorExpression expression, ImmutableList.Builder<ConnectorExpression> resultBuilder) {
        Call call;
        if (expression.equals((Object)Constant.TRUE)) {
            return;
        }
        if (expression instanceof Call && StandardFunctions.AND_FUNCTION_NAME.equals((Object)(call = (Call)expression).getFunctionName())) {
            for (ConnectorExpression argument : call.getArguments()) {
                ConnectorExpressions.extractConjuncts(argument, resultBuilder);
            }
            return;
        }
        resultBuilder.add((Object)expression);
    }

    public static ConnectorExpression and(ConnectorExpression ... expressions) {
        return ConnectorExpressions.and(Arrays.asList(expressions));
    }

    public static ConnectorExpression and(List<ConnectorExpression> expressions) {
        if ((expressions = (List)expressions.stream().filter(expression -> !expression.equals((Object)Constant.TRUE)).collect(ImmutableList.toImmutableList())).size() > 1) {
            return new Call((Type)BooleanType.BOOLEAN, StandardFunctions.AND_FUNCTION_NAME, expressions);
        }
        if (expressions.isEmpty()) {
            return Constant.TRUE;
        }
        return (ConnectorExpression)Iterables.getOnlyElement((Iterable)expressions);
    }

    private static Stream<ConnectorExpression> preOrder(ConnectorExpression expression) {
        return Streams.stream((Iterable)Traverser.forTree(ConnectorExpression::getChildren).depthFirstPreOrder((Object)Objects.requireNonNull(expression, "expression is null")));
    }
}

