/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.trino.spi.Node;
import io.trino.spi.NodeManager;
import io.trino.spi.NodeVersion;
import io.trino.spi.PageIndexerFactory;
import io.trino.spi.PageSorter;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.MetadataProvider;
import io.trino.spi.type.TypeManager;
import java.util.Objects;

public class ConnectorContextModule
implements Module {
    private final String catalogName;
    private final ConnectorContext context;

    public ConnectorContextModule(String catalogName, ConnectorContext context) {
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
        this.context = Objects.requireNonNull(context, "context is null");
    }

    public void configure(Binder binder) {
        binder.bind(CatalogName.class).toInstance((Object)new CatalogName(this.catalogName));
        binder.bind(OpenTelemetry.class).toInstance((Object)this.context.getOpenTelemetry());
        binder.bind(Tracer.class).toInstance((Object)this.context.getTracer());
        binder.bind(Node.class).toInstance((Object)this.context.getCurrentNode());
        binder.bind(NodeVersion.class).toInstance((Object)new NodeVersion(this.context.getCurrentNode().getVersion()));
        binder.bind(NodeManager.class).toInstance((Object)this.context.getNodeManager());
        binder.bind(VersionEmbedder.class).toInstance((Object)this.context.getVersionEmbedder());
        binder.bind(TypeManager.class).toInstance((Object)this.context.getTypeManager());
        binder.bind(MetadataProvider.class).toInstance((Object)this.context.getMetadataProvider());
        binder.bind(PageSorter.class).toInstance((Object)this.context.getPageSorter());
        binder.bind(PageIndexerFactory.class).toInstance((Object)this.context.getPageIndexerFactory());
    }
}

