/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.inject.Binder;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class JdkCompatibilityChecks {
    private final String inputArguments;
    private static final JdkCompatibilityChecks INSTANCE = new JdkCompatibilityChecks(ManagementFactory.getRuntimeMXBean().getInputArguments());

    @VisibleForTesting
    JdkCompatibilityChecks(List<String> inputArguments) {
        this.inputArguments = Joiner.on((String)" ").skipNulls().join((Iterable)Objects.requireNonNull(inputArguments, "inputArguments is null"));
    }

    public static void verifyConnectorAccessOpened(Binder binder, String connectorName, Multimap<String, String> modules) {
        INSTANCE.verifyAccessOpened(JdkCompatibilityChecks.wrap(binder), String.format("Connector '%s'", connectorName), modules);
    }

    public static void verifyConnectorUnsafeAllowed(Binder binder, String connectorName) {
        INSTANCE.verifyUnsafeAllowed(JdkCompatibilityChecks.wrap(binder), String.format("Connector '%s'", connectorName));
    }

    @VisibleForTesting
    void verifyAccessOpened(ThrowableSettable throwableSettable, String description, Multimap<String, String> modules) {
        ImmutableList.Builder missingJvmArguments = ImmutableList.builder();
        for (String fromModule : modules.keySet()) {
            for (String toModule : modules.get((Object)fromModule)) {
                String requiredJvmArgument = String.format(".*?--add-opens[\\s=]%s/%s=ALL-UNNAMED.*?", Pattern.quote(fromModule), Pattern.quote(toModule));
                if (this.inputArguments.matches(requiredJvmArgument)) continue;
                missingJvmArguments.add((Object)String.format("--add-opens=%s/%s=ALL-UNNAMED", fromModule, toModule));
            }
        }
        ImmutableList requiredJvmArguments = missingJvmArguments.build();
        if (!requiredJvmArguments.isEmpty()) {
            throwableSettable.setThrowable(new IllegalStateException(String.format("%s requires additional JVM argument(s). Please add the following to the JVM configuration: '%s'", description, String.join((CharSequence)" ", (Iterable<? extends CharSequence>)requiredJvmArguments))));
        }
    }

    @VisibleForTesting
    void verifyUnsafeAllowed(ThrowableSettable throwableSettable, String description) {
        String requiredJvmArgument = "--sun-misc-unsafe-memory-access=allow";
        if (!this.inputArguments.matches(".*?%s.*?".formatted(Pattern.quote(requiredJvmArgument)))) {
            throwableSettable.setThrowable(new IllegalStateException(String.format("%s requires additional JVM argument(s). Please add the following to the JVM configuration: '%s'", description, requiredJvmArgument)));
        }
    }

    private static ThrowableSettable wrap(Binder binder) {
        return throwable -> binder.addError(throwable.getMessage(), new Object[0]);
    }

    @VisibleForTesting
    static interface ThrowableSettable {
        public void setThrowable(Throwable var1);
    }
}

