/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.inject.Inject;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class ClassLoaderSafeSystemTable
implements SystemTable {
    private final SystemTable delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeSystemTable(@ForClassLoaderSafe SystemTable delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public SystemTable.Distribution getDistribution() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            SystemTable.Distribution distribution = this.delegate.getDistribution();
            return distribution;
        }
    }

    public ConnectorTableMetadata getTableMetadata() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ConnectorTableMetadata connectorTableMetadata = this.delegate.getTableMetadata();
            return connectorTableMetadata;
        }
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            RecordCursor recordCursor = this.delegate.cursor(transactionHandle, session, constraint);
            return recordCursor;
        }
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint, Set<Integer> requiredColumns, ConnectorSplit split) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            RecordCursor recordCursor = this.delegate.cursor(transactionHandle, session, constraint, requiredColumns, split);
            return recordCursor;
        }
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint, Set<Integer> requiredColumns, ConnectorSplit split, ConnectorAccessControl accessControl) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            RecordCursor recordCursor = this.delegate.cursor(transactionHandle, session, constraint, requiredColumns, split, accessControl);
            return recordCursor;
        }
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ConnectorPageSource connectorPageSource = this.delegate.pageSource(transactionHandle, session, constraint);
            return connectorPageSource;
        }
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint, ConnectorAccessControl accessControl) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            ConnectorPageSource connectorPageSource = this.delegate.pageSource(transactionHandle, session, constraint, accessControl);
            return connectorPageSource;
        }
    }

    public Optional<ConnectorSplitSource> splitSource(ConnectorSession connectorSession, TupleDomain<ColumnHandle> constraint) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.splitSource(connectorSession, constraint);
            return optional;
        }
    }
}

