/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base;

import com.google.common.primitives.Ints;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

public class MappedPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final int[] delegateFieldIndex;

    public MappedPageSource(ConnectorPageSource delegate, List<Integer> delegateFieldIndex) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.delegateFieldIndex = Ints.toArray((Collection)Objects.requireNonNull(delegateFieldIndex, "delegateFieldIndex is null"));
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public SourcePage getNextSourcePage() {
        SourcePage nextPage = this.delegate.getNextSourcePage();
        if (nextPage == null) {
            return null;
        }
        return new MappedSourcePage(nextPage, this.delegateFieldIndex);
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private record MappedSourcePage(SourcePage sourcePage, int[] channels) implements SourcePage
    {
        private MappedSourcePage {
            Objects.requireNonNull(sourcePage, "sourcePage is null");
            Objects.requireNonNull(channels, "channels is null");
        }

        public int getPositionCount() {
            return this.sourcePage.getPositionCount();
        }

        public long getSizeInBytes() {
            return this.sourcePage.getSizeInBytes();
        }

        public long getRetainedSizeInBytes() {
            return this.sourcePage.getRetainedSizeInBytes();
        }

        public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
            this.sourcePage.retainedBytesForEachPart(consumer);
        }

        public int getChannelCount() {
            return this.channels.length;
        }

        public Block getBlock(int channel) {
            return this.sourcePage.getBlock(this.channels[channel]);
        }

        public Page getPage() {
            return this.sourcePage.getColumns(this.channels);
        }

        public Page getColumns(int[] channels) {
            int[] newChannels = new int[channels.length];
            for (int i = 0; i < channels.length; ++i) {
                newChannels[i] = this.channels[channels[i]];
            }
            return this.sourcePage.getColumns(newChannels);
        }

        public void selectPositions(int[] positions, int offset, int size) {
            this.sourcePage.selectPositions(positions, offset, size);
        }
    }
}

