/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.authentication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;

public record KerberosConfiguration(KerberosPrincipal kerberosPrincipal, Map<String, String> options) {
    private static final String KERBEROS_LOGIN_MODULE = "com.sun.security.auth.module.Krb5LoginModule";
    private static final Pattern PRINCIPAL_NAME_PATTERN = Pattern.compile("(.*/)_HOST(@.*)?");

    public KerberosConfiguration {
        Objects.requireNonNull(kerberosPrincipal, "kerberosPrincipal is null");
        options = ImmutableMap.copyOf(Objects.requireNonNull(options, "options is null"));
    }

    public KerberosConfiguration withDebug() {
        ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
        optionsBuilder.putAll(this.options).put((Object)"debug", (Object)"true");
        return new KerberosConfiguration(this.kerberosPrincipal, (Map<String, String>)optionsBuilder.buildOrThrow());
    }

    public Configuration getConfiguration() {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosConfiguration.KERBEROS_LOGIN_MODULE, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, KerberosConfiguration.this.options)};
            }
        };
    }

    public static class Builder {
        private KerberosPrincipal kerberosPrincipal;
        private Optional<String> keytabLocation = Optional.empty();
        private Optional<String> credentialCacheLocation = Optional.empty();

        public Builder withKerberosPrincipal(String kerberosPrincipal) {
            this.kerberosPrincipal = Builder.createKerberosPrincipal(kerberosPrincipal);
            return this;
        }

        public Builder withKeytabLocation(String keytabLocation) {
            Builder.verifyFile(keytabLocation);
            this.keytabLocation = Optional.of(keytabLocation);
            return this;
        }

        public Builder withCredentialCacheLocation(String credentialCacheLocation) {
            Builder.verifyFile(credentialCacheLocation);
            this.credentialCacheLocation = Optional.of(credentialCacheLocation);
            return this;
        }

        public KerberosConfiguration build() {
            ImmutableMap.Builder optionsBuilder = ImmutableMap.builder().put((Object)"doNotPrompt", (Object)"true").put((Object)"isInitiator", (Object)"true").put((Object)"principal", (Object)this.kerberosPrincipal.getName());
            Preconditions.checkArgument((boolean)(this.keytabLocation.isPresent() ^ this.credentialCacheLocation.isPresent()), (Object)"Either keytab or credential cache must be specified");
            this.keytabLocation.ifPresent(keytab -> optionsBuilder.put((Object)"useKeyTab", (Object)"true").put((Object)"storeKey", (Object)"true").put((Object)"keyTab", keytab));
            this.credentialCacheLocation.ifPresent(credentialCache -> optionsBuilder.put((Object)"useTicketCache", (Object)"true").put((Object)"renewTGT", (Object)"true").put((Object)"ticketCache", credentialCache));
            return new KerberosConfiguration(this.kerberosPrincipal, (Map<String, String>)optionsBuilder.buildOrThrow());
        }

        private static KerberosPrincipal createKerberosPrincipal(String principal) {
            try {
                return new KerberosPrincipal(Builder.getServerPrincipal(principal, InetAddress.getLocalHost().getCanonicalHostName()));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @VisibleForTesting
        static String getServerPrincipal(String principal, String hostname) {
            Matcher matcher = PRINCIPAL_NAME_PATTERN.matcher(principal);
            if (matcher.matches()) {
                return matcher.replaceAll("$1" + hostname.toLowerCase(Locale.ENGLISH) + "$2");
            }
            return principal;
        }

        private static void verifyFile(String fileLocation) {
            Path filePath = Paths.get(fileLocation, new String[0]);
            Preconditions.checkArgument((boolean)Files.exists(filePath, new LinkOption[0]), (String)"File does not exist: %s", (Object)fileLocation);
            Preconditions.checkArgument((boolean)Files.isReadable(filePath), (String)"File is not readable: %s", (Object)fileLocation);
        }
    }
}

