/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Preconditions;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.SqlTime;
import io.trino.spi.type.SqlTimeWithTimeZone;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlTimestampWithTimeZone;
import io.trino.spi.type.SqlVarbinary;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;

public final class JsonTypeUtil {
    private static final JsonFactory JSON_FACTORY = ((JsonFactoryBuilder)JsonUtils.jsonFactoryBuilder().disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES)).build();
    private static final ObjectMapper SORTED_MAPPER = new ObjectMapperProvider().get().configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);

    private JsonTypeUtil() {
    }

    public static Slice jsonParse(Slice slice) {
        Slice slice2;
        block8: {
            JsonParser parser = JsonTypeUtil.createJsonParser(JSON_FACTORY, slice);
            try {
                DynamicSliceOutput output = new DynamicSliceOutput(slice.length());
                SORTED_MAPPER.writeValue((OutputStream)output, SORTED_MAPPER.readValue(parser, Object.class));
                Preconditions.checkState((parser.nextToken() == null ? 1 : 0) != 0, (Object)"Found characters after the expected end of input");
                slice2 = output.slice();
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | RuntimeException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, String.format("Cannot convert value to JSON: '%s'", slice.toStringUtf8()), (Throwable)e);
                }
            }
            parser.close();
        }
        return slice2;
    }

    public static Slice toJsonValue(List<?> values) throws IOException {
        if (values == null) {
            return Slices.utf8Slice((String)"[]");
        }
        StringJoiner joiner = new StringJoiner(",", "[", "]");
        Iterator<?> iterator = values.iterator();
        while (iterator.hasNext()) {
            String string;
            Object value;
            Object obj = value = iterator.next();
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SqlDate.class, SqlTime.class, SqlVarbinary.class, SqlTimeWithTimeZone.class, SqlDecimal.class, SqlTimestamp.class, SqlTimestampWithTimeZone.class}, obj, n)) {
                    case -1: {
                        string = "null";
                        break block5;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        if (!(obj instanceof SqlDate || obj instanceof SqlTime || obj instanceof SqlVarbinary || obj instanceof SqlTimeWithTimeZone || obj instanceof SqlDecimal || obj instanceof SqlTimestamp || obj instanceof SqlTimestampWithTimeZone)) {
                            n = 7;
                            continue block5;
                        }
                        string = SORTED_MAPPER.writeValueAsString((Object)value.toString());
                        break block5;
                    }
                    default: {
                        string = SORTED_MAPPER.writeValueAsString(value);
                        break block5;
                    }
                }
                break;
            }
            joiner.add(string);
        }
        return Slices.utf8Slice((String)joiner.toString());
    }

    private static JsonParser createJsonParser(JsonFactory factory, Slice json) throws IOException {
        return factory.createParser((Reader)new InputStreamReader((InputStream)json.getInput(), StandardCharsets.UTF_8));
    }
}

