/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.metrics.Timing;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DurationTiming
implements Timing<DurationTiming> {
    private final io.airlift.units.Duration duration;

    @JsonCreator
    public DurationTiming(@JsonProperty(value="duration") io.airlift.units.Duration duration) {
        this.duration = Objects.requireNonNull(duration, "duration is null");
    }

    @JsonProperty(value="duration")
    public io.airlift.units.Duration getAirliftDuration() {
        return this.duration;
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.duration.roundTo(TimeUnit.NANOSECONDS));
    }

    public DurationTiming mergeWith(DurationTiming other) {
        long durationNanos = this.duration.roundTo(TimeUnit.NANOSECONDS);
        long otherDurationNanos = other.getAirliftDuration().roundTo(TimeUnit.NANOSECONDS);
        return new DurationTiming(new io.airlift.units.Duration((double)(durationNanos + otherDurationNanos), TimeUnit.NANOSECONDS));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DurationTiming that = (DurationTiming)o;
        return this.duration.equals((Object)that.duration);
    }

    public int hashCode() {
        return Objects.hash(this.duration);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("duration", (Object)this.duration.convertToMostSuccinctTimeUnit()).toString();
    }
}

