/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import com.google.inject.Inject;
import io.trino.plugin.base.classloader.ForClassLoaderSafe;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class ClassLoaderSafeConnectorSplitSource
implements ConnectorSplitSource {
    private final ConnectorSplitSource delegate;
    private final ClassLoader classLoader;

    @Inject
    public ClassLoaderSafeConnectorSplitSource(@ForClassLoaderSafe ConnectorSplitSource delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            CompletableFuture completableFuture = this.delegate.getNextBatch(maxSize);
            return completableFuture;
        }
    }

    public Optional<List<Object>> getTableExecuteSplitsInfo() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Optional optional = this.delegate.getTableExecuteSplitsInfo();
            return optional;
        }
    }

    public void close() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            this.delegate.close();
        }
    }

    public boolean isFinished() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            boolean bl = this.delegate.isFinished();
            return bl;
        }
    }
}

