/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionDataProcessor;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import java.util.Objects;

public final class ClassLoaderSafeTableFunctionProcessorProvider
implements TableFunctionProcessorProvider {
    private final TableFunctionProcessorProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeTableFunctionProcessorProvider(TableFunctionProcessorProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public TableFunctionDataProcessor getDataProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            TableFunctionDataProcessor tableFunctionDataProcessor = this.delegate.getDataProcessor(session, handle);
            return tableFunctionDataProcessor;
        }
    }

    public TableFunctionSplitProcessor getSplitProcessor(ConnectorSession session, ConnectorTableFunctionHandle handle, ConnectorSplit split) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            TableFunctionSplitProcessor tableFunctionSplitProcessor = this.delegate.getSplitProcessor(session, handle, split);
            return tableFunctionSplitProcessor;
        }
    }
}

