/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.http.client.HttpClientBinder;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.base.security.CatalogAccessControlRule;
import io.trino.plugin.base.security.CatalogFunctionAccessControlRule;
import io.trino.plugin.base.security.CatalogProcedureAccessControlRule;
import io.trino.plugin.base.security.CatalogSchemaAccessControlRule;
import io.trino.plugin.base.security.CatalogSessionPropertyAccessControlRule;
import io.trino.plugin.base.security.CatalogTableAccessControlRule;
import io.trino.plugin.base.security.FileBasedAccessControlConfig;
import io.trino.plugin.base.security.FileBasedSystemAccessControl;
import io.trino.plugin.base.security.FileBasedSystemAccessControlRules;
import io.trino.plugin.base.security.ForAccessControlRules;
import io.trino.plugin.base.security.ForwardingSystemAccessControl;
import io.trino.plugin.base.security.HttpBasedAccessControlRulesProvider;
import io.trino.plugin.base.security.SessionPropertyAccessControlRule;
import io.trino.plugin.base.util.JsonUtils;
import io.trino.spi.security.SystemAccessControl;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public class FileBasedSystemAccessControlModule
extends AbstractConfigurationAwareModule {
    private static final Logger log = Logger.get(FileBasedSystemAccessControlModule.class);

    public void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(FileBasedAccessControlConfig.class);
        this.install(ConditionalModule.conditionalModule(FileBasedAccessControlConfig.class, FileBasedAccessControlConfig::isHttp, (Module)new HttpSystemAccessControlModule(), (Module)new LocalSystemAccessControlModule()));
    }

    @Inject
    @Provides
    @Singleton
    public SystemAccessControl getSystemAccessControl(LifeCycleManager lifeCycleManager, FileBasedAccessControlConfig config, Supplier<FileBasedSystemAccessControlRules> rulesProvider) {
        Duration refreshPeriod = config.getRefreshPeriod();
        if (refreshPeriod != null) {
            return ForwardingSystemAccessControl.of((Supplier<SystemAccessControl>)Suppliers.memoizeWithExpiration(() -> {
                log.info("Refreshing system access control from %s", new Object[]{config.getConfigFile()});
                return this.create(lifeCycleManager, (FileBasedSystemAccessControlRules)rulesProvider.get());
            }, (long)refreshPeriod.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        return this.create(lifeCycleManager, rulesProvider.get());
    }

    private SystemAccessControl create(LifeCycleManager lifeCycleManager, FileBasedSystemAccessControlRules rules) {
        ImmutableList catalogAccessControlRules;
        if (rules.getCatalogRules().isPresent()) {
            ImmutableList.Builder catalogRulesBuilder = ImmutableList.builder();
            catalogRulesBuilder.addAll((Iterable)rules.getCatalogRules().get());
            catalogRulesBuilder.add((Object)new CatalogAccessControlRule(CatalogAccessControlRule.AccessMode.ALL, Optional.of(Pattern.compile(".*")), Optional.empty(), Optional.empty(), Optional.of(Pattern.compile("system"))));
            catalogAccessControlRules = catalogRulesBuilder.build();
        } else {
            catalogAccessControlRules = ImmutableList.of((Object)CatalogAccessControlRule.ALLOW_ALL);
        }
        return FileBasedSystemAccessControl.builder().setLifeCycleManager(lifeCycleManager).setCatalogRules((List<CatalogAccessControlRule>)catalogAccessControlRules).setQueryAccessRules(rules.getQueryAccessRules()).setImpersonationRules(rules.getImpersonationRules()).setPrincipalUserMatchRules(rules.getPrincipalUserMatchRules()).setSystemInformationRules(rules.getSystemInformationRules()).setAuthorizationRules(rules.getAuthorizationRules()).setSchemaRules(rules.getSchemaRules().orElse((List<CatalogSchemaAccessControlRule>)ImmutableList.of((Object)CatalogSchemaAccessControlRule.ALLOW_ALL))).setTableRules(rules.getTableRules().orElse((List<CatalogTableAccessControlRule>)ImmutableList.of((Object)CatalogTableAccessControlRule.ALLOW_ALL))).setSessionPropertyRules(rules.getSessionPropertyRules().orElse((List<SessionPropertyAccessControlRule>)ImmutableList.of((Object)SessionPropertyAccessControlRule.ALLOW_ALL))).setCatalogSessionPropertyRules(rules.getCatalogSessionPropertyRules().orElse((List<CatalogSessionPropertyAccessControlRule>)ImmutableList.of((Object)CatalogSessionPropertyAccessControlRule.ALLOW_ALL))).setFunctionRules(rules.getFunctionRules().orElse((List<CatalogFunctionAccessControlRule>)ImmutableList.of((Object)CatalogFunctionAccessControlRule.ALLOW_BUILTIN))).setProcedureRules(rules.getProcedureRules().orElse((List<CatalogProcedureAccessControlRule>)ImmutableList.of((Object)CatalogProcedureAccessControlRule.ALLOW_BUILTIN))).build();
    }

    private static class HttpSystemAccessControlModule
    implements Module {
        private HttpSystemAccessControlModule() {
        }

        public void configure(Binder binder) {
            HttpClientBinder.httpClientBinder((Binder)binder).bindHttpClient("system-access-control", ForAccessControlRules.class).withConfigDefaults(config -> config.setRequestTimeout(Duration.succinctDuration((double)10.0, (TimeUnit)TimeUnit.SECONDS)).setSelectorCount(1).setMinThreads(1));
            binder.bind(HttpBasedAccessControlRulesProvider.class).in(Scopes.SINGLETON);
        }

        @Inject
        @Provides
        @Singleton
        public Supplier<FileBasedSystemAccessControlRules> getSystemAccessControlRules(HttpBasedAccessControlRulesProvider rulesProvider) {
            return () -> rulesProvider.extract(FileBasedSystemAccessControlRules.class);
        }
    }

    private static class LocalSystemAccessControlModule
    implements Module {
        private LocalSystemAccessControlModule() {
        }

        public void configure(Binder binder) {
        }

        @Inject
        @Provides
        @Singleton
        public Supplier<FileBasedSystemAccessControlRules> getSystemAccessControlRules(FileBasedAccessControlConfig config) {
            File configFile = new File(config.getConfigFile());
            return () -> JsonUtils.parseJson(configFile.toPath(), config.getJsonPointer(), FileBasedSystemAccessControlRules.class);
        }
    }
}

