/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.classloader;

import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import java.util.Objects;

public final class ClassLoaderSafeTableFunctionSplitProcessor
implements TableFunctionSplitProcessor {
    private final TableFunctionSplitProcessor delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeTableFunctionSplitProcessor(TableFunctionSplitProcessor delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public TableFunctionProcessorState process() {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            TableFunctionProcessorState tableFunctionProcessorState = this.delegate.process();
            return tableFunctionProcessorState;
        }
    }
}

