/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Preconditions;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaRoutineName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemAccessControlFactory;
import io.trino.spi.security.SystemSecurityContext;
import java.security.Principal;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ReadOnlySystemAccessControl
implements SystemAccessControl {
    public static final String NAME = "read-only";
    private static final ReadOnlySystemAccessControl INSTANCE = new ReadOnlySystemAccessControl();

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
    }

    public void checkCanExecuteQuery(Identity identity) {
    }

    public void checkCanViewQueryOwnedBy(Identity identity, Identity queryOwner) {
    }

    public Collection<Identity> filterViewQueryOwnedBy(Identity identity, Collection<Identity> queryOwners) {
        return queryOwners;
    }

    public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public boolean canAccessCatalog(SystemSecurityContext context, String catalogName) {
        return true;
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        return catalogs;
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        return schemaNames;
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return tableNames;
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
    }

    public Set<String> filterColumns(SystemSecurityContext context, CatalogSchemaTableName tableName, Set<String> columns) {
        return columns;
    }

    public Map<SchemaTableName, Set<String>> filterColumns(SystemSecurityContext context, String catalogName, Map<SchemaTableName, Set<String>> tableColumns) {
        return tableColumns;
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public void checkCanShowRoles(SystemSecurityContext context) {
    }

    public void checkCanShowCurrentRoles(SystemSecurityContext context) {
    }

    public boolean canExecuteFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        return ReadOnlySystemAccessControl.isSystemBuiltinSchema(functionName);
    }

    public boolean canCreateViewWithExecuteFunction(SystemSecurityContext systemSecurityContext, CatalogSchemaRoutineName functionName) {
        return ReadOnlySystemAccessControl.isSystemBuiltinSchema(functionName);
    }

    private static boolean isSystemBuiltinSchema(CatalogSchemaRoutineName functionName) {
        return functionName.getCatalogName().equals("system") && functionName.getSchemaName().equals("builtin");
    }

    public void checkCanShowFunctions(SystemSecurityContext context, CatalogSchemaName schema) {
    }

    public Set<SchemaFunctionName> filterFunctions(SystemSecurityContext context, String catalogName, Set<SchemaFunctionName> functionNames) {
        return functionNames;
    }

    public static class Factory
    implements SystemAccessControlFactory {
        public String getName() {
            return ReadOnlySystemAccessControl.NAME;
        }

        public SystemAccessControl create(Map<String, String> config) {
            Preconditions.checkArgument((boolean)config.isEmpty(), (Object)"This access controller does not support any configuration properties");
            return INSTANCE;
        }
    }
}

