/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.expression;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.ConnectorExpressionRule;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.expression.ConnectorExpression;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public final class ConnectorExpressionRewriter<Result> {
    private final Set<ConnectorExpressionRule<?, Result>> rules;

    public ConnectorExpressionRewriter(Set<ConnectorExpressionRule<?, Result>> rules) {
        this.rules = ImmutableSet.copyOf((Collection)Objects.requireNonNull(rules, "rules is null"));
    }

    public Optional<Result> rewrite(final ConnectorSession session, ConnectorExpression expression, final Map<String, ColumnHandle> assignments) {
        Objects.requireNonNull(session, "session is null");
        Objects.requireNonNull(expression, "expression is null");
        Objects.requireNonNull(assignments, "assignments is null");
        ConnectorExpressionRule.RewriteContext context = new ConnectorExpressionRule.RewriteContext<Result>(){

            @Override
            public Map<String, ColumnHandle> getAssignments() {
                return assignments;
            }

            @Override
            public ConnectorSession getSession() {
                return session;
            }

            @Override
            public Optional<Result> defaultRewrite(ConnectorExpression expression) {
                return ConnectorExpressionRewriter.this.rewrite(expression, this);
            }
        };
        return this.rewrite(expression, context);
    }

    private Optional<Result> rewrite(ConnectorExpression expression, ConnectorExpressionRule.RewriteContext<Result> context) {
        for (ConnectorExpressionRule<?, Result> rule : this.rules) {
            Optional<Result> rewritten = this.rewrite(rule, expression, context);
            if (!rewritten.isPresent()) continue;
            return rewritten;
        }
        return Optional.empty();
    }

    private <ExpressionType extends ConnectorExpression> Optional<Result> rewrite(ConnectorExpressionRule<ExpressionType, Result> rule, ConnectorExpression expression, ConnectorExpressionRule.RewriteContext<Result> context) {
        if (!rule.isEnabled(context.getSession())) {
            return Optional.empty();
        }
        Capture expressionCapture = Capture.newCapture();
        Pattern pattern = rule.getPattern().capturedAs(expressionCapture);
        Iterator matches = pattern.match((Object)expression, context).iterator();
        while (matches.hasNext()) {
            Match match = (Match)matches.next();
            ConnectorExpression capturedExpression = (ConnectorExpression)match.capture(expressionCapture);
            Verify.verify((capturedExpression == expression ? 1 : 0) != 0);
            Optional<Result> rewritten = rule.rewrite(capturedExpression, match.captures(), context);
            if (!rewritten.isPresent()) continue;
            return rewritten;
        }
        return Optional.empty();
    }
}

