/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.TrinoPrincipal;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class AuthorizationRule {
    private final Optional<Pattern> originalUserPattern;
    private final Optional<Pattern> originalGroupPattern;
    private final Optional<Pattern> originalRolePattern;
    private final Optional<Pattern> newUserPattern;
    private final Optional<Pattern> newRolePattern;
    private final boolean allow;

    @JsonCreator
    public AuthorizationRule(@JsonProperty(value="original_user") @JsonAlias(value={"originalUser"}) Optional<Pattern> originalUserPattern, @JsonProperty(value="original_group") @JsonAlias(value={"originalGroup"}) Optional<Pattern> originalGroupPattern, @JsonProperty(value="original_role") @JsonAlias(value={"originalRole"}) Optional<Pattern> originalRolePattern, @JsonProperty(value="new_user") @JsonAlias(value={"newUser"}) Optional<Pattern> newUserPattern, @JsonProperty(value="new_role") @JsonAlias(value={"newRole"}) Optional<Pattern> newRolePattern, @JsonProperty(value="allow") Boolean allow) {
        Preconditions.checkArgument((newUserPattern.isPresent() || newRolePattern.isPresent() ? 1 : 0) != 0, (Object)"At least one of new_use or new_role is required, none were provided");
        this.originalUserPattern = Objects.requireNonNull(originalUserPattern, "originalUserPattern is null");
        this.originalGroupPattern = Objects.requireNonNull(originalGroupPattern, "originalGroupPattern is null");
        this.originalRolePattern = Objects.requireNonNull(originalRolePattern, "originalRolePattern is null");
        this.newUserPattern = Objects.requireNonNull(newUserPattern, "newUserPattern is null");
        this.newRolePattern = Objects.requireNonNull(newRolePattern, "newRolePattern is null");
        this.allow = (Boolean)MoreObjects.firstNonNull((Object)allow, (Object)Boolean.TRUE);
    }

    public Optional<Boolean> match(String user, Set<String> groups, Set<String> roles, TrinoPrincipal newPrincipal) {
        if (this.originalUserPattern.map(regex -> regex.matcher(user).matches()).orElse(true).booleanValue() && (this.originalGroupPattern.isEmpty() || groups.stream().anyMatch(group -> this.originalGroupPattern.get().matcher((CharSequence)group).matches())) && (this.originalRolePattern.isEmpty() || roles.stream().anyMatch(role -> this.originalRolePattern.get().matcher((CharSequence)role).matches())) && this.matches(newPrincipal)) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }

    private boolean matches(TrinoPrincipal newPrincipal) {
        return switch (newPrincipal.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case PrincipalType.USER -> this.newUserPattern.map(regex -> regex.matcher(newPrincipal.getName()).matches()).orElse(false);
            case PrincipalType.ROLE -> this.newRolePattern.map(regex -> regex.matcher(newPrincipal.getName()).matches()).orElse(false);
        };
    }

    public Optional<Pattern> getOriginalRolePattern() {
        return this.originalRolePattern;
    }

    public Optional<Pattern> getNewRolePattern() {
        return this.newRolePattern;
    }
}

