/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.plugin.base.security.AnySchemaPermissionsRule;
import io.trino.spi.connector.SchemaRoutineName;
import io.trino.spi.function.FunctionKind;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;

public class FunctionAccessControlRule {
    public static final FunctionAccessControlRule ALLOW_ALL = new FunctionAccessControlRule((Set<FunctionPrivilege>)ImmutableSet.copyOf((Object[])FunctionPrivilege.values()), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Set<FunctionKind>)ImmutableSet.copyOf((Object[])FunctionKind.values()));
    private final Set<FunctionPrivilege> privileges;
    private final Optional<Pattern> userRegex;
    private final Optional<Pattern> roleRegex;
    private final Optional<Pattern> groupRegex;
    private final Optional<Pattern> schemaRegex;
    private final Optional<Pattern> functionRegex;
    private final Set<FunctionKind> functionKinds;
    private final boolean globalScopeFunctionKind;

    @JsonCreator
    public FunctionAccessControlRule(@JsonProperty(value="privileges") Set<FunctionPrivilege> privileges, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="role") Optional<Pattern> roleRegex, @JsonProperty(value="group") Optional<Pattern> groupRegex, @JsonProperty(value="schema") Optional<Pattern> schemaRegex, @JsonProperty(value="function") Optional<Pattern> functionRegex, @JsonProperty(value="function_kinds") @JsonAlias(value={"functionKinds"}) Set<FunctionKind> functionKinds) {
        this.privileges = ImmutableSet.copyOf((Collection)Objects.requireNonNull(privileges, "privileges is null"));
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.roleRegex = Objects.requireNonNull(roleRegex, "roleRegex is null");
        this.groupRegex = Objects.requireNonNull(groupRegex, "groupRegex is null");
        this.schemaRegex = Objects.requireNonNull(schemaRegex, "schemaRegex is null");
        this.functionRegex = Objects.requireNonNull(functionRegex, "functionRegex is null");
        this.functionKinds = Objects.requireNonNull(functionKinds, "functionKinds is null");
        Preconditions.checkState((!functionKinds.isEmpty() ? 1 : 0) != 0, (Object)("functionKinds cannot be empty, provide at least one function kind " + Arrays.toString(FunctionKind.values())));
        this.globalScopeFunctionKind = functionKinds.contains(FunctionKind.SCALAR) || functionKinds.contains(FunctionKind.AGGREGATE) || functionKinds.contains(FunctionKind.WINDOW);
        Preconditions.checkState((functionKinds.equals(Set.of(FunctionKind.TABLE)) || schemaRegex.isEmpty() ? 1 : 0) != 0, (Object)"Cannot define schema for others function kinds than TABLE");
    }

    public boolean matches(String user, Set<String> roles, Set<String> groups, String functionName) {
        return this.globalScopeFunctionKind && this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true) != false && this.roleRegex.map(regex -> roles.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true) != false && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true) != false && this.functionRegex.map(regex -> regex.matcher(functionName).matches()).orElse(true) != false;
    }

    public boolean matches(String user, Set<String> roles, Set<String> groups, FunctionKind functionKind, SchemaRoutineName functionName) {
        return this.functionKinds.contains(functionKind) && this.userRegex.map(regex -> regex.matcher(user).matches()).orElse(true) != false && this.roleRegex.map(regex -> roles.stream().anyMatch(role -> regex.matcher((CharSequence)role).matches())).orElse(true) != false && this.groupRegex.map(regex -> groups.stream().anyMatch(group -> regex.matcher((CharSequence)group).matches())).orElse(true) != false && this.schemaRegex.map(regex -> regex.matcher(functionName.getSchemaName()).matches()).orElse(true) != false && this.functionRegex.map(regex -> regex.matcher(functionName.getRoutineName()).matches()).orElse(true) != false;
    }

    public boolean canExecuteFunction() {
        return this.privileges.contains((Object)FunctionPrivilege.EXECUTE) || this.canGrantExecuteFunction();
    }

    public boolean canGrantExecuteFunction() {
        return this.privileges.contains((Object)FunctionPrivilege.GRANT_EXECUTE);
    }

    Optional<AnySchemaPermissionsRule> toAnySchemaPermissionsRule() {
        if (this.privileges.isEmpty() || !this.functionKinds.contains(FunctionKind.TABLE)) {
            return Optional.empty();
        }
        return Optional.of(new AnySchemaPermissionsRule(this.userRegex, this.roleRegex, this.groupRegex, this.schemaRegex));
    }

    Set<FunctionPrivilege> getPrivileges() {
        return this.privileges;
    }

    Optional<Pattern> getUserRegex() {
        return this.userRegex;
    }

    Optional<Pattern> getRoleRegex() {
        return this.roleRegex;
    }

    Optional<Pattern> getGroupRegex() {
        return this.groupRegex;
    }

    Optional<Pattern> getSchemaRegex() {
        return this.schemaRegex;
    }

    Set<FunctionKind> getFunctionKinds() {
        return this.functionKinds;
    }

    public static enum FunctionPrivilege {
        EXECUTE,
        GRANT_EXECUTE;

    }
}

