/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.security;

import com.google.common.base.Strings;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.io.File;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.NotNull;

public class FileBasedAccessControlConfig {
    public static final String SECURITY_CONFIG_FILE = "security.config-file";
    public static final String SECURITY_REFRESH_PERIOD = "security.refresh-period";
    private String configFile;
    private Duration refreshPeriod;
    private String jsonPointer = "";

    @NotNull
    public String getConfigFile() {
        return this.configFile;
    }

    @Config(value="security.config-file")
    public FileBasedAccessControlConfig setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    @Config(value="security.refresh-period")
    public FileBasedAccessControlConfig setRefreshPeriod(Duration refreshPeriod) {
        this.refreshPeriod = refreshPeriod;
        return this;
    }

    @NotNull
    public String getJsonPointer() {
        return this.jsonPointer;
    }

    @Config(value="security.json-pointer")
    @ConfigDescription(value="JSON pointer (RFC 6901) to mappings inside JSON config")
    public FileBasedAccessControlConfig setJsonPointer(String jsonPointer) {
        this.jsonPointer = jsonPointer;
        return this;
    }

    public boolean isHttp() {
        String nonNullConfigFile = Strings.nullToEmpty((String)this.configFile);
        return nonNullConfigFile.startsWith("https://") || nonNullConfigFile.startsWith("http://");
    }

    @AssertTrue(message="Config file does not exist.")
    public @AssertTrue(message="Config file does not exist.") boolean isConfigFileValid() {
        return this.isHttp() || new File(Strings.nullToEmpty((String)this.configFile)).exists();
    }
}

