/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.base.metrics;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.stats.TDigest;
import io.trino.spi.metrics.Distribution;
import java.util.Base64;
import java.util.Locale;

public class TDigestHistogram
implements Distribution<TDigestHistogram> {
    @JsonSerialize(converter=TDigestToBase64Converter.class)
    @JsonDeserialize(converter=Base64ToTDigestConverter.class)
    private final TDigest digest;

    public static TDigestHistogram fromValue(double value) {
        return TDigestHistogram.fromValue(value, 1.0);
    }

    public static TDigestHistogram fromValue(double value, double weight) {
        TDigest digest = new TDigest();
        digest.add(value, weight);
        return new TDigestHistogram(digest);
    }

    @JsonCreator
    public TDigestHistogram(TDigest digest) {
        this.digest = digest;
    }

    @JsonProperty
    public TDigest getDigest() {
        return TDigest.copyOf((TDigest)this.digest);
    }

    public TDigestHistogram mergeWith(TDigestHistogram other) {
        TDigest result = TDigest.copyOf((TDigest)this.digest);
        result.mergeWith(other.getDigest());
        return new TDigestHistogram(result);
    }

    @JsonProperty
    public long getTotal() {
        return (long)this.digest.getCount();
    }

    @JsonProperty
    public synchronized double getMin() {
        return this.digest.getMin();
    }

    @JsonProperty
    public synchronized double getMax() {
        return this.digest.getMax();
    }

    @JsonProperty
    public synchronized double getP01() {
        return this.digest.valueAt(0.01);
    }

    @JsonProperty
    public synchronized double getP05() {
        return this.digest.valueAt(0.05);
    }

    @JsonProperty
    public synchronized double getP10() {
        return this.digest.valueAt(0.1);
    }

    @JsonProperty
    public synchronized double getP25() {
        return this.digest.valueAt(0.25);
    }

    @JsonProperty
    public synchronized double getP50() {
        return this.digest.valueAt(0.5);
    }

    @JsonProperty
    public synchronized double getP75() {
        return this.digest.valueAt(0.75);
    }

    @JsonProperty
    public synchronized double getP90() {
        return this.digest.valueAt(0.9);
    }

    @JsonProperty
    public synchronized double getP95() {
        return this.digest.valueAt(0.95);
    }

    @JsonProperty
    public synchronized double getP99() {
        return this.digest.valueAt(0.99);
    }

    public double getPercentile(double percentile) {
        return this.digest.valueAt(percentile / 100.0);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"").add("count", (Object)TDigestHistogram.formatDouble(this.digest.getCount())).add("p01", (Object)TDigestHistogram.formatDouble(this.getP01())).add("p05", (Object)TDigestHistogram.formatDouble(this.getP05())).add("p10", (Object)TDigestHistogram.formatDouble(this.getP10())).add("p25", (Object)TDigestHistogram.formatDouble(this.getP25())).add("p50", (Object)TDigestHistogram.formatDouble(this.getP50())).add("p75", (Object)TDigestHistogram.formatDouble(this.getP75())).add("p90", (Object)TDigestHistogram.formatDouble(this.getP90())).add("p95", (Object)TDigestHistogram.formatDouble(this.getP95())).add("p99", (Object)TDigestHistogram.formatDouble(this.getP99())).add("min", (Object)TDigestHistogram.formatDouble(this.getMin())).add("max", (Object)TDigestHistogram.formatDouble(this.getMax()));
        return helper.toString();
    }

    private static String formatDouble(double value) {
        return String.format(Locale.US, "%.2f", value);
    }

    public static class Base64ToTDigestConverter
    extends StdConverter<String, TDigest> {
        public TDigest convert(String value) {
            Slice slice = Slices.wrappedBuffer((byte[])Base64.getDecoder().decode(value));
            return TDigest.deserialize((Slice)slice);
        }
    }

    public static class TDigestToBase64Converter
    extends StdConverter<TDigest, String> {
        public String convert(TDigest value) {
            Slice slice = value.serialize();
            return Base64.getEncoder().encodeToString(slice.getBytes());
        }
    }
}

